package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCommonGroup invokes the devops_rdc.UpdateCommonGroup API synchronously
func (client *Client) UpdateCommonGroup(request *UpdateCommonGroupRequest) (response *UpdateCommonGroupResponse, err error) {
	response = CreateUpdateCommonGroupResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCommonGroupWithChan invokes the devops_rdc.UpdateCommonGroup API asynchronously
func (client *Client) UpdateCommonGroupWithChan(request *UpdateCommonGroupRequest) (<-chan *UpdateCommonGroupResponse, <-chan error) {
	responseChan := make(chan *UpdateCommonGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCommonGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCommonGroupWithCallback invokes the devops_rdc.UpdateCommonGroup API asynchronously
func (client *Client) UpdateCommonGroupWithCallback(request *UpdateCommonGroupRequest, callback func(response *UpdateCommonGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCommonGroupResponse
		var err error
		defer close(result)
		response, err = client.UpdateCommonGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCommonGroupRequest is the request struct for api UpdateCommonGroup
type UpdateCommonGroupRequest struct {
	*requests.RpcRequest
	Description   string `position:"Body" name:"Description"`
	CommonGroupId string `position:"Body" name:"CommonGroupId"`
	OrgId         string `position:"Body" name:"OrgId"`
	SmartGroupId  string `position:"Body" name:"SmartGroupId"`
	Name          string `position:"Body" name:"Name"`
	ProjectId     string `position:"Body" name:"ProjectId"`
}

// UpdateCommonGroupResponse is the response struct for api UpdateCommonGroup
type UpdateCommonGroupResponse struct {
	*responses.BaseResponse
	Successful bool   `json:"Successful" xml:"Successful"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Object     Object `json:"Object" xml:"Object"`
}

// CreateUpdateCommonGroupRequest creates a request to invoke UpdateCommonGroup API
func CreateUpdateCommonGroupRequest() (request *UpdateCommonGroupRequest) {
	request = &UpdateCommonGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "UpdateCommonGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateCommonGroupResponse creates a response to parse from UpdateCommonGroup response
func CreateUpdateCommonGroupResponse() (response *UpdateCommonGroupResponse) {
	response = &UpdateCommonGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
