package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeL7RsPolicy invokes the ddoscoo.DescribeL7RsPolicy API synchronously
func (client *Client) DescribeL7RsPolicy(request *DescribeL7RsPolicyRequest) (response *DescribeL7RsPolicyResponse, err error) {
	response = CreateDescribeL7RsPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeL7RsPolicyWithChan invokes the ddoscoo.DescribeL7RsPolicy API asynchronously
func (client *Client) DescribeL7RsPolicyWithChan(request *DescribeL7RsPolicyRequest) (<-chan *DescribeL7RsPolicyResponse, <-chan error) {
	responseChan := make(chan *DescribeL7RsPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeL7RsPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeL7RsPolicyWithCallback invokes the ddoscoo.DescribeL7RsPolicy API asynchronously
func (client *Client) DescribeL7RsPolicyWithCallback(request *DescribeL7RsPolicyRequest, callback func(response *DescribeL7RsPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeL7RsPolicyResponse
		var err error
		defer close(result)
		response, err = client.DescribeL7RsPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeL7RsPolicyRequest is the request struct for api DescribeL7RsPolicy
type DescribeL7RsPolicyRequest struct {
	*requests.RpcRequest
	ResourceGroupId string    `position:"Query" name:"ResourceGroupId"`
	RealServers     *[]string `position:"Query" name:"RealServers"  type:"Repeated"`
	SourceIp        string    `position:"Query" name:"SourceIp"`
	Domain          string    `position:"Query" name:"Domain"`
}

// DescribeL7RsPolicyResponse is the response struct for api DescribeL7RsPolicy
type DescribeL7RsPolicyResponse struct {
	*responses.BaseResponse
	RequestId  string          `json:"RequestId" xml:"RequestId"`
	ProxyMode  string          `json:"ProxyMode" xml:"ProxyMode"`
	Attributes []AttributeItem `json:"Attributes" xml:"Attributes"`
}

// CreateDescribeL7RsPolicyRequest creates a request to invoke DescribeL7RsPolicy API
func CreateDescribeL7RsPolicyRequest() (request *DescribeL7RsPolicyRequest) {
	request = &DescribeL7RsPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeL7RsPolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeL7RsPolicyResponse creates a response to parse from DescribeL7RsPolicy response
func CreateDescribeL7RsPolicyResponse() (response *DescribeL7RsPolicyResponse) {
	response = &DescribeL7RsPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
