package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainViewSourceCountries invokes the ddoscoo.DescribeDomainViewSourceCountries API synchronously
func (client *Client) DescribeDomainViewSourceCountries(request *DescribeDomainViewSourceCountriesRequest) (response *DescribeDomainViewSourceCountriesResponse, err error) {
	response = CreateDescribeDomainViewSourceCountriesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainViewSourceCountriesWithChan invokes the ddoscoo.DescribeDomainViewSourceCountries API asynchronously
func (client *Client) DescribeDomainViewSourceCountriesWithChan(request *DescribeDomainViewSourceCountriesRequest) (<-chan *DescribeDomainViewSourceCountriesResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainViewSourceCountriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainViewSourceCountries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainViewSourceCountriesWithCallback invokes the ddoscoo.DescribeDomainViewSourceCountries API asynchronously
func (client *Client) DescribeDomainViewSourceCountriesWithCallback(request *DescribeDomainViewSourceCountriesRequest, callback func(response *DescribeDomainViewSourceCountriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainViewSourceCountriesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainViewSourceCountries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainViewSourceCountriesRequest is the request struct for api DescribeDomainViewSourceCountries
type DescribeDomainViewSourceCountriesRequest struct {
	*requests.RpcRequest
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Domain          string           `position:"Query" name:"Domain"`
}

// DescribeDomainViewSourceCountriesResponse is the response struct for api DescribeDomainViewSourceCountries
type DescribeDomainViewSourceCountriesResponse struct {
	*responses.BaseResponse
	RequestId      string    `json:"RequestId" xml:"RequestId"`
	SourceCountrys []Country `json:"SourceCountrys" xml:"SourceCountrys"`
}

// CreateDescribeDomainViewSourceCountriesRequest creates a request to invoke DescribeDomainViewSourceCountries API
func CreateDescribeDomainViewSourceCountriesRequest() (request *DescribeDomainViewSourceCountriesRequest) {
	request = &DescribeDomainViewSourceCountriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeDomainViewSourceCountries", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainViewSourceCountriesResponse creates a response to parse from DescribeDomainViewSourceCountries response
func CreateDescribeDomainViewSourceCountriesResponse() (response *DescribeDomainViewSourceCountriesResponse) {
	response = &DescribeDomainViewSourceCountriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
