package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAutoCcWhitelist invokes the ddoscoo.DescribeAutoCcWhitelist API synchronously
func (client *Client) DescribeAutoCcWhitelist(request *DescribeAutoCcWhitelistRequest) (response *DescribeAutoCcWhitelistResponse, err error) {
	response = CreateDescribeAutoCcWhitelistResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAutoCcWhitelistWithChan invokes the ddoscoo.DescribeAutoCcWhitelist API asynchronously
func (client *Client) DescribeAutoCcWhitelistWithChan(request *DescribeAutoCcWhitelistRequest) (<-chan *DescribeAutoCcWhitelistResponse, <-chan error) {
	responseChan := make(chan *DescribeAutoCcWhitelistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAutoCcWhitelist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAutoCcWhitelistWithCallback invokes the ddoscoo.DescribeAutoCcWhitelist API asynchronously
func (client *Client) DescribeAutoCcWhitelistWithCallback(request *DescribeAutoCcWhitelistRequest, callback func(response *DescribeAutoCcWhitelistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAutoCcWhitelistResponse
		var err error
		defer close(result)
		response, err = client.DescribeAutoCcWhitelist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAutoCcWhitelistRequest is the request struct for api DescribeAutoCcWhitelist
type DescribeAutoCcWhitelistRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	SourceIp   string           `position:"Query" name:"SourceIp"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	KeyWord    string           `position:"Query" name:"KeyWord"`
}

// DescribeAutoCcWhitelistResponse is the response struct for api DescribeAutoCcWhitelist
type DescribeAutoCcWhitelistResponse struct {
	*responses.BaseResponse
	RequestId       string                `json:"RequestId" xml:"RequestId"`
	TotalCount      int64                 `json:"TotalCount" xml:"TotalCount"`
	AutoCcWhitelist []AutoCcWhitelistItem `json:"AutoCcWhitelist" xml:"AutoCcWhitelist"`
}

// CreateDescribeAutoCcWhitelistRequest creates a request to invoke DescribeAutoCcWhitelist API
func CreateDescribeAutoCcWhitelistRequest() (request *DescribeAutoCcWhitelistRequest) {
	request = &DescribeAutoCcWhitelistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeAutoCcWhitelist", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeAutoCcWhitelistResponse creates a response to parse from DescribeAutoCcWhitelist response
func CreateDescribeAutoCcWhitelistResponse() (response *DescribeAutoCcWhitelistResponse) {
	response = &DescribeAutoCcWhitelistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
