package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDomainResource invokes the ddoscoo.DeleteDomainResource API synchronously
func (client *Client) DeleteDomainResource(request *DeleteDomainResourceRequest) (response *DeleteDomainResourceResponse, err error) {
	response = CreateDeleteDomainResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDomainResourceWithChan invokes the ddoscoo.DeleteDomainResource API asynchronously
func (client *Client) DeleteDomainResourceWithChan(request *DeleteDomainResourceRequest) (<-chan *DeleteDomainResourceResponse, <-chan error) {
	responseChan := make(chan *DeleteDomainResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDomainResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDomainResourceWithCallback invokes the ddoscoo.DeleteDomainResource API asynchronously
func (client *Client) DeleteDomainResourceWithCallback(request *DeleteDomainResourceRequest, callback func(response *DeleteDomainResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDomainResourceResponse
		var err error
		defer close(result)
		response, err = client.DeleteDomainResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDomainResourceRequest is the request struct for api DeleteDomainResource
type DeleteDomainResourceRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Domain   string `position:"Query" name:"Domain"`
}

// DeleteDomainResourceResponse is the response struct for api DeleteDomainResource
type DeleteDomainResourceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDomainResourceRequest creates a request to invoke DeleteDomainResource API
func CreateDeleteDomainResourceRequest() (request *DeleteDomainResourceRequest) {
	request = &DeleteDomainResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DeleteDomainResource", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDomainResourceResponse creates a response to parse from DeleteDomainResource response
func CreateDeleteDomainResourceResponse() (response *DeleteDomainResourceResponse) {
	response = &DeleteDomainResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
