package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnOfflineLogDeliveryStatus invokes the dcdn.DescribeDcdnOfflineLogDeliveryStatus API synchronously
func (client *Client) DescribeDcdnOfflineLogDeliveryStatus(request *DescribeDcdnOfflineLogDeliveryStatusRequest) (response *DescribeDcdnOfflineLogDeliveryStatusResponse, err error) {
	response = CreateDescribeDcdnOfflineLogDeliveryStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnOfflineLogDeliveryStatusWithChan invokes the dcdn.DescribeDcdnOfflineLogDeliveryStatus API asynchronously
func (client *Client) DescribeDcdnOfflineLogDeliveryStatusWithChan(request *DescribeDcdnOfflineLogDeliveryStatusRequest) (<-chan *DescribeDcdnOfflineLogDeliveryStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnOfflineLogDeliveryStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnOfflineLogDeliveryStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnOfflineLogDeliveryStatusWithCallback invokes the dcdn.DescribeDcdnOfflineLogDeliveryStatus API asynchronously
func (client *Client) DescribeDcdnOfflineLogDeliveryStatusWithCallback(request *DescribeDcdnOfflineLogDeliveryStatusRequest, callback func(response *DescribeDcdnOfflineLogDeliveryStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnOfflineLogDeliveryStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnOfflineLogDeliveryStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnOfflineLogDeliveryStatusRequest is the request struct for api DescribeDcdnOfflineLogDeliveryStatus
type DescribeDcdnOfflineLogDeliveryStatusRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDcdnOfflineLogDeliveryStatusResponse is the response struct for api DescribeDcdnOfflineLogDeliveryStatus
type DescribeDcdnOfflineLogDeliveryStatusResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	OpenStatus string `json:"OpenStatus" xml:"OpenStatus"`
}

// CreateDescribeDcdnOfflineLogDeliveryStatusRequest creates a request to invoke DescribeDcdnOfflineLogDeliveryStatus API
func CreateDescribeDcdnOfflineLogDeliveryStatusRequest() (request *DescribeDcdnOfflineLogDeliveryStatusRequest) {
	request = &DescribeDcdnOfflineLogDeliveryStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnOfflineLogDeliveryStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnOfflineLogDeliveryStatusResponse creates a response to parse from DescribeDcdnOfflineLogDeliveryStatus response
func CreateDescribeDcdnOfflineLogDeliveryStatusResponse() (response *DescribeDcdnOfflineLogDeliveryStatusResponse) {
	response = &DescribeDcdnOfflineLogDeliveryStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
