package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnOfflineLogDeliveryRegions invokes the dcdn.DescribeDcdnOfflineLogDeliveryRegions API synchronously
func (client *Client) DescribeDcdnOfflineLogDeliveryRegions(request *DescribeDcdnOfflineLogDeliveryRegionsRequest) (response *DescribeDcdnOfflineLogDeliveryRegionsResponse, err error) {
	response = CreateDescribeDcdnOfflineLogDeliveryRegionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnOfflineLogDeliveryRegionsWithChan invokes the dcdn.DescribeDcdnOfflineLogDeliveryRegions API asynchronously
func (client *Client) DescribeDcdnOfflineLogDeliveryRegionsWithChan(request *DescribeDcdnOfflineLogDeliveryRegionsRequest) (<-chan *DescribeDcdnOfflineLogDeliveryRegionsResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnOfflineLogDeliveryRegionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnOfflineLogDeliveryRegions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnOfflineLogDeliveryRegionsWithCallback invokes the dcdn.DescribeDcdnOfflineLogDeliveryRegions API asynchronously
func (client *Client) DescribeDcdnOfflineLogDeliveryRegionsWithCallback(request *DescribeDcdnOfflineLogDeliveryRegionsRequest, callback func(response *DescribeDcdnOfflineLogDeliveryRegionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnOfflineLogDeliveryRegionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnOfflineLogDeliveryRegions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnOfflineLogDeliveryRegionsRequest is the request struct for api DescribeDcdnOfflineLogDeliveryRegions
type DescribeDcdnOfflineLogDeliveryRegionsRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDcdnOfflineLogDeliveryRegionsResponse is the response struct for api DescribeDcdnOfflineLogDeliveryRegions
type DescribeDcdnOfflineLogDeliveryRegionsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Areas     []Area `json:"Areas" xml:"Areas"`
}

// CreateDescribeDcdnOfflineLogDeliveryRegionsRequest creates a request to invoke DescribeDcdnOfflineLogDeliveryRegions API
func CreateDescribeDcdnOfflineLogDeliveryRegionsRequest() (request *DescribeDcdnOfflineLogDeliveryRegionsRequest) {
	request = &DescribeDcdnOfflineLogDeliveryRegionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnOfflineLogDeliveryRegions", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnOfflineLogDeliveryRegionsResponse creates a response to parse from DescribeDcdnOfflineLogDeliveryRegions response
func CreateDescribeDcdnOfflineLogDeliveryRegionsResponse() (response *DescribeDcdnOfflineLogDeliveryRegionsResponse) {
	response = &DescribeDcdnOfflineLogDeliveryRegionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
