package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainProperty invokes the dcdn.DescribeDcdnDomainProperty API synchronously
func (client *Client) DescribeDcdnDomainProperty(request *DescribeDcdnDomainPropertyRequest) (response *DescribeDcdnDomainPropertyResponse, err error) {
	response = CreateDescribeDcdnDomainPropertyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainPropertyWithChan invokes the dcdn.DescribeDcdnDomainProperty API asynchronously
func (client *Client) DescribeDcdnDomainPropertyWithChan(request *DescribeDcdnDomainPropertyRequest) (<-chan *DescribeDcdnDomainPropertyResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainPropertyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainProperty(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainPropertyWithCallback invokes the dcdn.DescribeDcdnDomainProperty API asynchronously
func (client *Client) DescribeDcdnDomainPropertyWithCallback(request *DescribeDcdnDomainPropertyRequest, callback func(response *DescribeDcdnDomainPropertyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainPropertyResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainProperty(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainPropertyRequest is the request struct for api DescribeDcdnDomainProperty
type DescribeDcdnDomainPropertyRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDcdnDomainPropertyResponse is the response struct for api DescribeDcdnDomainProperty
type DescribeDcdnDomainPropertyResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DomainName string `json:"DomainName" xml:"DomainName"`
	Protocol   string `json:"Protocol" xml:"Protocol"`
}

// CreateDescribeDcdnDomainPropertyRequest creates a request to invoke DescribeDcdnDomainProperty API
func CreateDescribeDcdnDomainPropertyRequest() (request *DescribeDcdnDomainPropertyRequest) {
	request = &DescribeDcdnDomainPropertyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainProperty", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDomainPropertyResponse creates a response to parse from DescribeDcdnDomainProperty response
func CreateDescribeDcdnDomainPropertyResponse() (response *DescribeDcdnDomainPropertyResponse) {
	response = &DescribeDcdnDomainPropertyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
