package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SyncHDMAliyunResource invokes the das.SyncHDMAliyunResource API synchronously
func (client *Client) SyncHDMAliyunResource(request *SyncHDMAliyunResourceRequest) (response *SyncHDMAliyunResourceResponse, err error) {
	response = CreateSyncHDMAliyunResourceResponse()
	err = client.DoAction(request, response)
	return
}

// SyncHDMAliyunResourceWithChan invokes the das.SyncHDMAliyunResource API asynchronously
func (client *Client) SyncHDMAliyunResourceWithChan(request *SyncHDMAliyunResourceRequest) (<-chan *SyncHDMAliyunResourceResponse, <-chan error) {
	responseChan := make(chan *SyncHDMAliyunResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SyncHDMAliyunResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SyncHDMAliyunResourceWithCallback invokes the das.SyncHDMAliyunResource API asynchronously
func (client *Client) SyncHDMAliyunResourceWithCallback(request *SyncHDMAliyunResourceRequest, callback func(response *SyncHDMAliyunResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SyncHDMAliyunResourceResponse
		var err error
		defer close(result)
		response, err = client.SyncHDMAliyunResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SyncHDMAliyunResourceRequest is the request struct for api SyncHDMAliyunResource
type SyncHDMAliyunResourceRequest struct {
	*requests.RpcRequest
	SkipAuth                 string `position:"Query" name:"skipAuth"`
	Context                  string `position:"Query" name:"__context"`
	Signature                string `position:"Query" name:"signature"`
	ResourceTypes            string `position:"Query" name:"ResourceTypes"`
	UserId                   string `position:"Query" name:"UserId"`
	WaitForModifySecurityIps string `position:"Query" name:"WaitForModifySecurityIps"`
	Uid                      string `position:"Query" name:"Uid"`
	Async                    string `position:"Query" name:"Async"`
	AccessKey                string `position:"Query" name:"accessKey"`
	Timestamp                string `position:"Query" name:"timestamp"`
}

// SyncHDMAliyunResourceResponse is the response struct for api SyncHDMAliyunResource
type SyncHDMAliyunResourceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Synchro   string `json:"Synchro" xml:"Synchro"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateSyncHDMAliyunResourceRequest creates a request to invoke SyncHDMAliyunResource API
func CreateSyncHDMAliyunResourceRequest() (request *SyncHDMAliyunResourceRequest) {
	request = &SyncHDMAliyunResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "SyncHDMAliyunResource", "das", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSyncHDMAliyunResourceResponse creates a response to parse from SyncHDMAliyunResource response
func CreateSyncHDMAliyunResourceResponse() (response *SyncHDMAliyunResourceResponse) {
	response = &SyncHDMAliyunResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
