package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHDMLastAliyunResourceSyncResult invokes the das.GetHDMLastAliyunResourceSyncResult API synchronously
func (client *Client) GetHDMLastAliyunResourceSyncResult(request *GetHDMLastAliyunResourceSyncResultRequest) (response *GetHDMLastAliyunResourceSyncResultResponse, err error) {
	response = CreateGetHDMLastAliyunResourceSyncResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetHDMLastAliyunResourceSyncResultWithChan invokes the das.GetHDMLastAliyunResourceSyncResult API asynchronously
func (client *Client) GetHDMLastAliyunResourceSyncResultWithChan(request *GetHDMLastAliyunResourceSyncResultRequest) (<-chan *GetHDMLastAliyunResourceSyncResultResponse, <-chan error) {
	responseChan := make(chan *GetHDMLastAliyunResourceSyncResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHDMLastAliyunResourceSyncResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHDMLastAliyunResourceSyncResultWithCallback invokes the das.GetHDMLastAliyunResourceSyncResult API asynchronously
func (client *Client) GetHDMLastAliyunResourceSyncResultWithCallback(request *GetHDMLastAliyunResourceSyncResultRequest, callback func(response *GetHDMLastAliyunResourceSyncResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHDMLastAliyunResourceSyncResultResponse
		var err error
		defer close(result)
		response, err = client.GetHDMLastAliyunResourceSyncResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHDMLastAliyunResourceSyncResultRequest is the request struct for api GetHDMLastAliyunResourceSyncResult
type GetHDMLastAliyunResourceSyncResultRequest struct {
	*requests.RpcRequest
	SkipAuth  string `position:"Query" name:"skipAuth"`
	Context   string `position:"Query" name:"__context"`
	Signature string `position:"Query" name:"signature"`
	UserId    string `position:"Query" name:"UserId"`
	Uid       string `position:"Query" name:"Uid"`
	AccessKey string `position:"Query" name:"accessKey"`
	Timestamp string `position:"Query" name:"timestamp"`
}

// GetHDMLastAliyunResourceSyncResultResponse is the response struct for api GetHDMLastAliyunResourceSyncResult
type GetHDMLastAliyunResourceSyncResultResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Synchro   string `json:"Synchro" xml:"Synchro"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetHDMLastAliyunResourceSyncResultRequest creates a request to invoke GetHDMLastAliyunResourceSyncResult API
func CreateGetHDMLastAliyunResourceSyncResultRequest() (request *GetHDMLastAliyunResourceSyncResultRequest) {
	request = &GetHDMLastAliyunResourceSyncResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetHDMLastAliyunResourceSyncResult", "das", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetHDMLastAliyunResourceSyncResultResponse creates a response to parse from GetHDMLastAliyunResourceSyncResult response
func CreateGetHDMLastAliyunResourceSyncResultResponse() (response *GetHDMLastAliyunResourceSyncResultResponse) {
	response = &GetHDMLastAliyunResourceSyncResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
