package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAutonomousNotifyEventDetail invokes the das.GetAutonomousNotifyEventDetail API synchronously
func (client *Client) GetAutonomousNotifyEventDetail(request *GetAutonomousNotifyEventDetailRequest) (response *GetAutonomousNotifyEventDetailResponse, err error) {
	response = CreateGetAutonomousNotifyEventDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetAutonomousNotifyEventDetailWithChan invokes the das.GetAutonomousNotifyEventDetail API asynchronously
func (client *Client) GetAutonomousNotifyEventDetailWithChan(request *GetAutonomousNotifyEventDetailRequest) (<-chan *GetAutonomousNotifyEventDetailResponse, <-chan error) {
	responseChan := make(chan *GetAutonomousNotifyEventDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAutonomousNotifyEventDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAutonomousNotifyEventDetailWithCallback invokes the das.GetAutonomousNotifyEventDetail API asynchronously
func (client *Client) GetAutonomousNotifyEventDetailWithCallback(request *GetAutonomousNotifyEventDetailRequest, callback func(response *GetAutonomousNotifyEventDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAutonomousNotifyEventDetailResponse
		var err error
		defer close(result)
		response, err = client.GetAutonomousNotifyEventDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAutonomousNotifyEventDetailRequest is the request struct for api GetAutonomousNotifyEventDetail
type GetAutonomousNotifyEventDetailRequest struct {
	*requests.RpcRequest
	Context    string `position:"Query" name:"__context"`
	SpanId     string `position:"Query" name:"SpanId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetAutonomousNotifyEventDetailResponse is the response struct for api GetAutonomousNotifyEventDetail
type GetAutonomousNotifyEventDetailResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateGetAutonomousNotifyEventDetailRequest creates a request to invoke GetAutonomousNotifyEventDetail API
func CreateGetAutonomousNotifyEventDetailRequest() (request *GetAutonomousNotifyEventDetailRequest) {
	request = &GetAutonomousNotifyEventDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetAutonomousNotifyEventDetail", "das", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAutonomousNotifyEventDetailResponse creates a response to parse from GetAutonomousNotifyEventDetail response
func CreateGetAutonomousNotifyEventDetailResponse() (response *GetAutonomousNotifyEventDetailResponse) {
	response = &GetAutonomousNotifyEventDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
