package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAutonomousNotifyEventContent invokes the das.GetAutonomousNotifyEventContent API synchronously
func (client *Client) GetAutonomousNotifyEventContent(request *GetAutonomousNotifyEventContentRequest) (response *GetAutonomousNotifyEventContentResponse, err error) {
	response = CreateGetAutonomousNotifyEventContentResponse()
	err = client.DoAction(request, response)
	return
}

// GetAutonomousNotifyEventContentWithChan invokes the das.GetAutonomousNotifyEventContent API asynchronously
func (client *Client) GetAutonomousNotifyEventContentWithChan(request *GetAutonomousNotifyEventContentRequest) (<-chan *GetAutonomousNotifyEventContentResponse, <-chan error) {
	responseChan := make(chan *GetAutonomousNotifyEventContentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAutonomousNotifyEventContent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAutonomousNotifyEventContentWithCallback invokes the das.GetAutonomousNotifyEventContent API asynchronously
func (client *Client) GetAutonomousNotifyEventContentWithCallback(request *GetAutonomousNotifyEventContentRequest, callback func(response *GetAutonomousNotifyEventContentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAutonomousNotifyEventContentResponse
		var err error
		defer close(result)
		response, err = client.GetAutonomousNotifyEventContent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAutonomousNotifyEventContentRequest is the request struct for api GetAutonomousNotifyEventContent
type GetAutonomousNotifyEventContentRequest struct {
	*requests.RpcRequest
	Context    string `position:"Query" name:"__context"`
	SpanId     string `position:"Query" name:"SpanId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetAutonomousNotifyEventContentResponse is the response struct for api GetAutonomousNotifyEventContent
type GetAutonomousNotifyEventContentResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateGetAutonomousNotifyEventContentRequest creates a request to invoke GetAutonomousNotifyEventContent API
func CreateGetAutonomousNotifyEventContentRequest() (request *GetAutonomousNotifyEventContentRequest) {
	request = &GetAutonomousNotifyEventContentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetAutonomousNotifyEventContent", "das", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAutonomousNotifyEventContentResponse creates a response to parse from GetAutonomousNotifyEventContent response
func CreateGetAutonomousNotifyEventContentResponse() (response *GetAutonomousNotifyEventContentResponse) {
	response = &GetAutonomousNotifyEventContentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
