package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableAllSqlConcurrencyControlRules invokes the das.DisableAllSqlConcurrencyControlRules API synchronously
func (client *Client) DisableAllSqlConcurrencyControlRules(request *DisableAllSqlConcurrencyControlRulesRequest) (response *DisableAllSqlConcurrencyControlRulesResponse, err error) {
	response = CreateDisableAllSqlConcurrencyControlRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DisableAllSqlConcurrencyControlRulesWithChan invokes the das.DisableAllSqlConcurrencyControlRules API asynchronously
func (client *Client) DisableAllSqlConcurrencyControlRulesWithChan(request *DisableAllSqlConcurrencyControlRulesRequest) (<-chan *DisableAllSqlConcurrencyControlRulesResponse, <-chan error) {
	responseChan := make(chan *DisableAllSqlConcurrencyControlRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableAllSqlConcurrencyControlRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableAllSqlConcurrencyControlRulesWithCallback invokes the das.DisableAllSqlConcurrencyControlRules API asynchronously
func (client *Client) DisableAllSqlConcurrencyControlRulesWithCallback(request *DisableAllSqlConcurrencyControlRulesRequest, callback func(response *DisableAllSqlConcurrencyControlRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableAllSqlConcurrencyControlRulesResponse
		var err error
		defer close(result)
		response, err = client.DisableAllSqlConcurrencyControlRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableAllSqlConcurrencyControlRulesRequest is the request struct for api DisableAllSqlConcurrencyControlRules
type DisableAllSqlConcurrencyControlRulesRequest struct {
	*requests.RpcRequest
	ConsoleContext string `position:"Query" name:"ConsoleContext"`
	InstanceId     string `position:"Query" name:"InstanceId"`
}

// DisableAllSqlConcurrencyControlRulesResponse is the response struct for api DisableAllSqlConcurrencyControlRules
type DisableAllSqlConcurrencyControlRulesResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateDisableAllSqlConcurrencyControlRulesRequest creates a request to invoke DisableAllSqlConcurrencyControlRules API
func CreateDisableAllSqlConcurrencyControlRulesRequest() (request *DisableAllSqlConcurrencyControlRulesRequest) {
	request = &DisableAllSqlConcurrencyControlRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "DisableAllSqlConcurrencyControlRules", "das", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableAllSqlConcurrencyControlRulesResponse creates a response to parse from DisableAllSqlConcurrencyControlRules response
func CreateDisableAllSqlConcurrencyControlRulesResponse() (response *DisableAllSqlConcurrencyControlRulesResponse) {
	response = &DisableAllSqlConcurrencyControlRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
