package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCloudbenchTaskConfig invokes the das.DescribeCloudbenchTaskConfig API synchronously
func (client *Client) DescribeCloudbenchTaskConfig(request *DescribeCloudbenchTaskConfigRequest) (response *DescribeCloudbenchTaskConfigResponse, err error) {
	response = CreateDescribeCloudbenchTaskConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCloudbenchTaskConfigWithChan invokes the das.DescribeCloudbenchTaskConfig API asynchronously
func (client *Client) DescribeCloudbenchTaskConfigWithChan(request *DescribeCloudbenchTaskConfigRequest) (<-chan *DescribeCloudbenchTaskConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeCloudbenchTaskConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCloudbenchTaskConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCloudbenchTaskConfigWithCallback invokes the das.DescribeCloudbenchTaskConfig API asynchronously
func (client *Client) DescribeCloudbenchTaskConfigWithCallback(request *DescribeCloudbenchTaskConfigRequest, callback func(response *DescribeCloudbenchTaskConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCloudbenchTaskConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeCloudbenchTaskConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCloudbenchTaskConfigRequest is the request struct for api DescribeCloudbenchTaskConfig
type DescribeCloudbenchTaskConfigRequest struct {
	*requests.RpcRequest
	TaskId string `position:"Query" name:"TaskId"`
}

// DescribeCloudbenchTaskConfigResponse is the response struct for api DescribeCloudbenchTaskConfig
type DescribeCloudbenchTaskConfigResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeCloudbenchTaskConfigRequest creates a request to invoke DescribeCloudbenchTaskConfig API
func CreateDescribeCloudbenchTaskConfigRequest() (request *DescribeCloudbenchTaskConfigRequest) {
	request = &DescribeCloudbenchTaskConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "DescribeCloudbenchTaskConfig", "das", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCloudbenchTaskConfigResponse creates a response to parse from DescribeCloudbenchTaskConfig response
func CreateDescribeCloudbenchTaskConfigResponse() (response *DescribeCloudbenchTaskConfigResponse) {
	response = &DescribeCloudbenchTaskConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
