package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutConfigRule invokes the config.PutConfigRule API synchronously
func (client *Client) PutConfigRule(request *PutConfigRuleRequest) (response *PutConfigRuleResponse, err error) {
	response = CreatePutConfigRuleResponse()
	err = client.DoAction(request, response)
	return
}

// PutConfigRuleWithChan invokes the config.PutConfigRule API asynchronously
func (client *Client) PutConfigRuleWithChan(request *PutConfigRuleRequest) (<-chan *PutConfigRuleResponse, <-chan error) {
	responseChan := make(chan *PutConfigRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutConfigRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutConfigRuleWithCallback invokes the config.PutConfigRule API asynchronously
func (client *Client) PutConfigRuleWithCallback(request *PutConfigRuleRequest, callback func(response *PutConfigRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutConfigRuleResponse
		var err error
		defer close(result)
		response, err = client.PutConfigRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutConfigRuleRequest is the request struct for api PutConfigRule
type PutConfigRuleRequest struct {
	*requests.RpcRequest
	ConfigRuleId                    string           `position:"Body" name:"ConfigRuleId"`
	MultiAccount                    requests.Boolean `position:"Query" name:"MultiAccount"`
	ClientToken                     string           `position:"Body" name:"ClientToken"`
	Description                     string           `position:"Body" name:"Description"`
	SourceIdentifier                string           `position:"Body" name:"SourceIdentifier"`
	SourceMaximumExecutionFrequency string           `position:"Body" name:"SourceMaximumExecutionFrequency"`
	ScopeComplianceResourceTypes    string           `position:"Body" name:"ScopeComplianceResourceTypes"`
	SourceDetailMessageType         string           `position:"Body" name:"SourceDetailMessageType"`
	RiskLevel                       requests.Integer `position:"Body" name:"RiskLevel"`
	SourceOwner                     string           `position:"Body" name:"SourceOwner"`
	InputParameters                 string           `position:"Body" name:"InputParameters"`
	ConfigRuleName                  string           `position:"Body" name:"ConfigRuleName"`
	ScopeComplianceResourceId       string           `position:"Body" name:"ScopeComplianceResourceId"`
	MemberId                        requests.Integer `position:"Query" name:"MemberId"`
}

// PutConfigRuleResponse is the response struct for api PutConfigRule
type PutConfigRuleResponse struct {
	*responses.BaseResponse
	ConfigRuleId string `json:"ConfigRuleId" xml:"ConfigRuleId"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
}

// CreatePutConfigRuleRequest creates a request to invoke PutConfigRule API
func CreatePutConfigRuleRequest() (request *PutConfigRuleRequest) {
	request = &PutConfigRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2019-01-08", "PutConfigRule", "Config", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePutConfigRuleResponse creates a response to parse from PutConfigRule response
func CreatePutConfigRuleResponse() (response *PutConfigRuleResponse) {
	response = &PutConfigRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
