package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSupportedResourceTypes invokes the config.GetSupportedResourceTypes API synchronously
func (client *Client) GetSupportedResourceTypes(request *GetSupportedResourceTypesRequest) (response *GetSupportedResourceTypesResponse, err error) {
	response = CreateGetSupportedResourceTypesResponse()
	err = client.DoAction(request, response)
	return
}

// GetSupportedResourceTypesWithChan invokes the config.GetSupportedResourceTypes API asynchronously
func (client *Client) GetSupportedResourceTypesWithChan(request *GetSupportedResourceTypesRequest) (<-chan *GetSupportedResourceTypesResponse, <-chan error) {
	responseChan := make(chan *GetSupportedResourceTypesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSupportedResourceTypes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSupportedResourceTypesWithCallback invokes the config.GetSupportedResourceTypes API asynchronously
func (client *Client) GetSupportedResourceTypesWithCallback(request *GetSupportedResourceTypesRequest, callback func(response *GetSupportedResourceTypesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSupportedResourceTypesResponse
		var err error
		defer close(result)
		response, err = client.GetSupportedResourceTypes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSupportedResourceTypesRequest is the request struct for api GetSupportedResourceTypes
type GetSupportedResourceTypesRequest struct {
	*requests.RpcRequest
}

// GetSupportedResourceTypesResponse is the response struct for api GetSupportedResourceTypes
type GetSupportedResourceTypesResponse struct {
	*responses.BaseResponse
	RequestId     string   `json:"RequestId" xml:"RequestId"`
	ResourceTypes []string `json:"ResourceTypes" xml:"ResourceTypes"`
}

// CreateGetSupportedResourceTypesRequest creates a request to invoke GetSupportedResourceTypes API
func CreateGetSupportedResourceTypesRequest() (request *GetSupportedResourceTypesRequest) {
	request = &GetSupportedResourceTypesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2019-01-08", "GetSupportedResourceTypes", "Config", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetSupportedResourceTypesResponse creates a response to parse from GetSupportedResourceTypes response
func CreateGetSupportedResourceTypesResponse() (response *GetSupportedResourceTypesResponse) {
	response = &GetSupportedResourceTypesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
