package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// WriteCommunicationLog invokes the companyreg.WriteCommunicationLog API synchronously
func (client *Client) WriteCommunicationLog(request *WriteCommunicationLogRequest) (response *WriteCommunicationLogResponse, err error) {
	response = CreateWriteCommunicationLogResponse()
	err = client.DoAction(request, response)
	return
}

// WriteCommunicationLogWithChan invokes the companyreg.WriteCommunicationLog API asynchronously
func (client *Client) WriteCommunicationLogWithChan(request *WriteCommunicationLogRequest) (<-chan *WriteCommunicationLogResponse, <-chan error) {
	responseChan := make(chan *WriteCommunicationLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.WriteCommunicationLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// WriteCommunicationLogWithCallback invokes the companyreg.WriteCommunicationLog API asynchronously
func (client *Client) WriteCommunicationLogWithCallback(request *WriteCommunicationLogRequest, callback func(response *WriteCommunicationLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *WriteCommunicationLogResponse
		var err error
		defer close(result)
		response, err = client.WriteCommunicationLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// WriteCommunicationLogRequest is the request struct for api WriteCommunicationLog
type WriteCommunicationLogRequest struct {
	*requests.RpcRequest
	Note     string `position:"Query" name:"Note"`
	TargetId string `position:"Query" name:"TargetId"`
	BizId    string `position:"Query" name:"BizId"`
}

// WriteCommunicationLogResponse is the response struct for api WriteCommunicationLog
type WriteCommunicationLogResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateWriteCommunicationLogRequest creates a request to invoke WriteCommunicationLog API
func CreateWriteCommunicationLogRequest() (request *WriteCommunicationLogRequest) {
	request = &WriteCommunicationLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "WriteCommunicationLog", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateWriteCommunicationLogResponse creates a response to parse from WriteCommunicationLog response
func CreateWriteCommunicationLogResponse() (response *WriteCommunicationLogResponse) {
	response = &WriteCommunicationLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
