package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ScanInvoice invokes the companyreg.ScanInvoice API synchronously
func (client *Client) ScanInvoice(request *ScanInvoiceRequest) (response *ScanInvoiceResponse, err error) {
	response = CreateScanInvoiceResponse()
	err = client.DoAction(request, response)
	return
}

// ScanInvoiceWithChan invokes the companyreg.ScanInvoice API asynchronously
func (client *Client) ScanInvoiceWithChan(request *ScanInvoiceRequest) (<-chan *ScanInvoiceResponse, <-chan error) {
	responseChan := make(chan *ScanInvoiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ScanInvoice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ScanInvoiceWithCallback invokes the companyreg.ScanInvoice API asynchronously
func (client *Client) ScanInvoiceWithCallback(request *ScanInvoiceRequest, callback func(response *ScanInvoiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ScanInvoiceResponse
		var err error
		defer close(result)
		response, err = client.ScanInvoice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ScanInvoiceRequest is the request struct for api ScanInvoice
type ScanInvoiceRequest struct {
	*requests.RpcRequest
	Date        string `position:"Query" name:"Date"`
	No          string `position:"Query" name:"No"`
	Amount      string `position:"Query" name:"Amount"`
	Code        string `position:"Query" name:"Code"`
	VCode       string `position:"Query" name:"VCode"`
	BizId       string `position:"Query" name:"BizId"`
	InvoiceCode string `position:"Query" name:"InvoiceCode"`
}

// ScanInvoiceResponse is the response struct for api ScanInvoice
type ScanInvoiceResponse struct {
	*responses.BaseResponse
	Code      string  `json:"Code" xml:"Code"`
	IsFee     bool    `json:"IsFee" xml:"IsFee"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Success   bool    `json:"Success" xml:"Success"`
	Invoice   Invoice `json:"Invoice" xml:"Invoice"`
}

// CreateScanInvoiceRequest creates a request to invoke ScanInvoice API
func CreateScanInvoiceRequest() (request *ScanInvoiceRequest) {
	request = &ScanInvoiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "ScanInvoice", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateScanInvoiceResponse creates a response to parse from ScanInvoice response
func CreateScanInvoiceResponse() (response *ScanInvoiceResponse) {
	response = &ScanInvoiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
