package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVoucher invokes the companyreg.ListVoucher API synchronously
func (client *Client) ListVoucher(request *ListVoucherRequest) (response *ListVoucherResponse, err error) {
	response = CreateListVoucherResponse()
	err = client.DoAction(request, response)
	return
}

// ListVoucherWithChan invokes the companyreg.ListVoucher API asynchronously
func (client *Client) ListVoucherWithChan(request *ListVoucherRequest) (<-chan *ListVoucherResponse, <-chan error) {
	responseChan := make(chan *ListVoucherResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVoucher(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVoucherWithCallback invokes the companyreg.ListVoucher API asynchronously
func (client *Client) ListVoucherWithCallback(request *ListVoucherRequest, callback func(response *ListVoucherResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVoucherResponse
		var err error
		defer close(result)
		response, err = client.ListVoucher(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVoucherRequest is the request struct for api ListVoucher
type ListVoucherRequest struct {
	*requests.RpcRequest
	Period       string           `position:"Query" name:"Period"`
	PageCount    requests.Integer `position:"Query" name:"PageCount"`
	CodeSortType string           `position:"Query" name:"CodeSortType"`
	BizId        string           `position:"Query" name:"BizId"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	Text         string           `position:"Query" name:"Text"`
}

// ListVoucherResponse is the response struct for api ListVoucher
type ListVoucherResponse struct {
	*responses.BaseResponse
	PageCount  int          `json:"PageCount" xml:"PageCount"`
	PageSize   int          `json:"PageSize" xml:"PageSize"`
	RequestId  string       `json:"RequestId" xml:"RequestId"`
	TotalCount int          `json:"TotalCount" xml:"TotalCount"`
	Result     []ResultItem `json:"Result" xml:"Result"`
}

// CreateListVoucherRequest creates a request to invoke ListVoucher API
func CreateListVoucherRequest() (request *ListVoucherRequest) {
	request = &ListVoucherRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "ListVoucher", "companyreg", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListVoucherResponse creates a response to parse from ListVoucher response
func CreateListVoucherResponse() (response *ListVoucherResponse) {
	response = &ListVoucherResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
