package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIcpApplications invokes the companyreg.ListIcpApplications API synchronously
func (client *Client) ListIcpApplications(request *ListIcpApplicationsRequest) (response *ListIcpApplicationsResponse, err error) {
	response = CreateListIcpApplicationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListIcpApplicationsWithChan invokes the companyreg.ListIcpApplications API asynchronously
func (client *Client) ListIcpApplicationsWithChan(request *ListIcpApplicationsRequest) (<-chan *ListIcpApplicationsResponse, <-chan error) {
	responseChan := make(chan *ListIcpApplicationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIcpApplications(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIcpApplicationsWithCallback invokes the companyreg.ListIcpApplications API asynchronously
func (client *Client) ListIcpApplicationsWithCallback(request *ListIcpApplicationsRequest, callback func(response *ListIcpApplicationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIcpApplicationsResponse
		var err error
		defer close(result)
		response, err = client.ListIcpApplications(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIcpApplicationsRequest is the request struct for api ListIcpApplications
type ListIcpApplicationsRequest struct {
	*requests.RpcRequest
	IntentionBizId    string           `position:"Query" name:"IntentionBizId"`
	Type              requests.Integer `position:"Query" name:"Type"`
	ApplicationStatus requests.Integer `position:"Query" name:"ApplicationStatus"`
	PageNumber        requests.Integer `position:"Query" name:"PageNumber"`
	CompanyName       string           `position:"Query" name:"CompanyName"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	SortOrder         string           `position:"Query" name:"SortOrder"`
	SortField         string           `position:"Query" name:"SortField"`
}

// ListIcpApplicationsResponse is the response struct for api ListIcpApplications
type ListIcpApplicationsResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	TotalCount   int           `json:"TotalCount" xml:"TotalCount"`
	PageSize     int           `json:"PageSize" xml:"PageSize"`
	PageNumber   int           `json:"PageNumber" xml:"PageNumber"`
	Source       string        `json:"Source" xml:"Source"`
	Applications []Application `json:"Applications" xml:"Applications"`
}

// CreateListIcpApplicationsRequest creates a request to invoke ListIcpApplications API
func CreateListIcpApplicationsRequest() (request *ListIcpApplicationsRequest) {
	request = &ListIcpApplicationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "ListIcpApplications", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListIcpApplicationsResponse creates a response to parse from ListIcpApplications response
func CreateListIcpApplicationsResponse() (response *ListIcpApplicationsResponse) {
	response = &ListIcpApplicationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
