package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVoucherCount invokes the companyreg.GetVoucherCount API synchronously
func (client *Client) GetVoucherCount(request *GetVoucherCountRequest) (response *GetVoucherCountResponse, err error) {
	response = CreateGetVoucherCountResponse()
	err = client.DoAction(request, response)
	return
}

// GetVoucherCountWithChan invokes the companyreg.GetVoucherCount API asynchronously
func (client *Client) GetVoucherCountWithChan(request *GetVoucherCountRequest) (<-chan *GetVoucherCountResponse, <-chan error) {
	responseChan := make(chan *GetVoucherCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVoucherCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVoucherCountWithCallback invokes the companyreg.GetVoucherCount API asynchronously
func (client *Client) GetVoucherCountWithCallback(request *GetVoucherCountRequest, callback func(response *GetVoucherCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVoucherCountResponse
		var err error
		defer close(result)
		response, err = client.GetVoucherCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVoucherCountRequest is the request struct for api GetVoucherCount
type GetVoucherCountRequest struct {
	*requests.RpcRequest
	BizId       string `position:"Query" name:"BizId"`
	StartPeriod string `position:"Query" name:"StartPeriod"`
	EndPeriod   string `position:"Query" name:"EndPeriod"`
}

// GetVoucherCountResponse is the response struct for api GetVoucherCount
type GetVoucherCountResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetVoucherCountRequest creates a request to invoke GetVoucherCount API
func CreateGetVoucherCountRequest() (request *GetVoucherCountRequest) {
	request = &GetVoucherCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetVoucherCount", "companyreg", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetVoucherCountResponse creates a response to parse from GetVoucherCount response
func CreateGetVoucherCountResponse() (response *GetVoucherCountResponse) {
	response = &GetVoucherCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
