package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTaxInfo invokes the companyreg.GetTaxInfo API synchronously
func (client *Client) GetTaxInfo(request *GetTaxInfoRequest) (response *GetTaxInfoResponse, err error) {
	response = CreateGetTaxInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetTaxInfoWithChan invokes the companyreg.GetTaxInfo API asynchronously
func (client *Client) GetTaxInfoWithChan(request *GetTaxInfoRequest) (<-chan *GetTaxInfoResponse, <-chan error) {
	responseChan := make(chan *GetTaxInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTaxInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTaxInfoWithCallback invokes the companyreg.GetTaxInfo API asynchronously
func (client *Client) GetTaxInfoWithCallback(request *GetTaxInfoRequest, callback func(response *GetTaxInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTaxInfoResponse
		var err error
		defer close(result)
		response, err = client.GetTaxInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTaxInfoRequest is the request struct for api GetTaxInfo
type GetTaxInfoRequest struct {
	*requests.RpcRequest
	CityArea string `position:"Query" name:"CityArea"`
	BizId    string `position:"Query" name:"BizId"`
	Periods  string `position:"Query" name:"Periods"`
}

// GetTaxInfoResponse is the response struct for api GetTaxInfo
type GetTaxInfoResponse struct {
	*responses.BaseResponse
	TaxPreparerName      string `json:"TaxPreparerName" xml:"TaxPreparerName"`
	TaxiationAgentSecret string `json:"TaxiationAgentSecret" xml:"TaxiationAgentSecret"`
	MyTaxInfo            string `json:"MyTaxInfo" xml:"MyTaxInfo"`
	TaxArea              string `json:"TaxArea" xml:"TaxArea"`
	AcctgSystem          string `json:"AcctgSystem" xml:"AcctgSystem"`
	RequestId            string `json:"RequestId" xml:"RequestId"`
	ExternalUniqueId     string `json:"ExternalUniqueId" xml:"ExternalUniqueId"`
	TaxTypes             string `json:"TaxTypes" xml:"TaxTypes"`
	IncomeDeclarationPsw string `json:"IncomeDeclarationPsw" xml:"IncomeDeclarationPsw"`
	IsNeedSmsCode        string `json:"IsNeedSmsCode" xml:"IsNeedSmsCode"`
	TaxNo                string `json:"TaxNo" xml:"TaxNo"`
	TaxpayerType         string `json:"TaxpayerType" xml:"TaxpayerType"`
	Name                 string `json:"Name" xml:"Name"`
	TaxPreparerPsw       string `json:"TaxPreparerPsw" xml:"TaxPreparerPsw"`
	TaxAreaCode          string `json:"TaxAreaCode" xml:"TaxAreaCode"`
	TenantId             int64  `json:"TenantId" xml:"TenantId"`
}

// CreateGetTaxInfoRequest creates a request to invoke GetTaxInfo API
func CreateGetTaxInfoRequest() (request *GetTaxInfoRequest) {
	request = &GetTaxInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetTaxInfo", "companyreg", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetTaxInfoResponse creates a response to parse from GetTaxInfo response
func CreateGetTaxInfoResponse() (response *GetTaxInfoResponse) {
	response = &GetTaxInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
