package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEnterprisesInfo invokes the companyreg.GetEnterprisesInfo API synchronously
func (client *Client) GetEnterprisesInfo(request *GetEnterprisesInfoRequest) (response *GetEnterprisesInfoResponse, err error) {
	response = CreateGetEnterprisesInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetEnterprisesInfoWithChan invokes the companyreg.GetEnterprisesInfo API asynchronously
func (client *Client) GetEnterprisesInfoWithChan(request *GetEnterprisesInfoRequest) (<-chan *GetEnterprisesInfoResponse, <-chan error) {
	responseChan := make(chan *GetEnterprisesInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEnterprisesInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEnterprisesInfoWithCallback invokes the companyreg.GetEnterprisesInfo API asynchronously
func (client *Client) GetEnterprisesInfoWithCallback(request *GetEnterprisesInfoRequest, callback func(response *GetEnterprisesInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEnterprisesInfoResponse
		var err error
		defer close(result)
		response, err = client.GetEnterprisesInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEnterprisesInfoRequest is the request struct for api GetEnterprisesInfo
type GetEnterprisesInfoRequest struct {
	*requests.RpcRequest
	CreditCode     string `position:"Query" name:"CreditCode"`
	EnterpriseName string `position:"Query" name:"EnterpriseName"`
}

// GetEnterprisesInfoResponse is the response struct for api GetEnterprisesInfo
type GetEnterprisesInfoResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	EnterpriseName    string `json:"EnterpriseName" xml:"EnterpriseName"`
	TaxNo             string `json:"TaxNo" xml:"TaxNo"`
	Corporation       string `json:"Corporation" xml:"Corporation"`
	EstablishDate     string `json:"EstablishDate" xml:"EstablishDate"`
	EnterpriseType    string `json:"EnterpriseType" xml:"EnterpriseType"`
	RegisteredCapital string `json:"RegisteredCapital" xml:"RegisteredCapital"`
	Address           string `json:"Address" xml:"Address"`
	BusinessScope     string `json:"BusinessScope" xml:"BusinessScope"`
	FromBusinessTerm  string `json:"FromBusinessTerm" xml:"FromBusinessTerm"`
	ToBusinessTerm    string `json:"ToBusinessTerm" xml:"ToBusinessTerm"`
	EnterpriseStatus  string `json:"EnterpriseStatus" xml:"EnterpriseStatus"`
	IndustryCoName    string `json:"IndustryCoName" xml:"IndustryCoName"`
	IndustryCode      string `json:"IndustryCode" xml:"IndustryCode"`
	EntityType        string `json:"EntityType" xml:"EntityType"`
	AreaName          string `json:"AreaName" xml:"AreaName"`
	RegCityName       string `json:"RegCityName" xml:"RegCityName"`
	ChangeDate        string `json:"ChangeDate" xml:"ChangeDate"`
}

// CreateGetEnterprisesInfoRequest creates a request to invoke GetEnterprisesInfo API
func CreateGetEnterprisesInfoRequest() (request *GetEnterprisesInfoRequest) {
	request = &GetEnterprisesInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetEnterprisesInfo", "companyreg", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetEnterprisesInfoResponse creates a response to parse from GetEnterprisesInfo response
func CreateGetEnterprisesInfoResponse() (response *GetEnterprisesInfoResponse) {
	response = &GetEnterprisesInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
