package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateCompanyRegUploadPolicy invokes the companyreg.GenerateCompanyRegUploadPolicy API synchronously
func (client *Client) GenerateCompanyRegUploadPolicy(request *GenerateCompanyRegUploadPolicyRequest) (response *GenerateCompanyRegUploadPolicyResponse, err error) {
	response = CreateGenerateCompanyRegUploadPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateCompanyRegUploadPolicyWithChan invokes the companyreg.GenerateCompanyRegUploadPolicy API asynchronously
func (client *Client) GenerateCompanyRegUploadPolicyWithChan(request *GenerateCompanyRegUploadPolicyRequest) (<-chan *GenerateCompanyRegUploadPolicyResponse, <-chan error) {
	responseChan := make(chan *GenerateCompanyRegUploadPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateCompanyRegUploadPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateCompanyRegUploadPolicyWithCallback invokes the companyreg.GenerateCompanyRegUploadPolicy API asynchronously
func (client *Client) GenerateCompanyRegUploadPolicyWithCallback(request *GenerateCompanyRegUploadPolicyRequest, callback func(response *GenerateCompanyRegUploadPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateCompanyRegUploadPolicyResponse
		var err error
		defer close(result)
		response, err = client.GenerateCompanyRegUploadPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateCompanyRegUploadPolicyRequest is the request struct for api GenerateCompanyRegUploadPolicy
type GenerateCompanyRegUploadPolicyRequest struct {
	*requests.RpcRequest
	Data       string `position:"Query" name:"Data"`
	BizCode    string `position:"Query" name:"BizCode"`
	BizSubCode string `position:"Query" name:"BizSubCode"`
}

// GenerateCompanyRegUploadPolicyResponse is the response struct for api GenerateCompanyRegUploadPolicy
type GenerateCompanyRegUploadPolicyResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	AccessId      string `json:"AccessId" xml:"AccessId"`
	Signature     string `json:"Signature" xml:"Signature"`
	FileDir       string `json:"FileDir" xml:"FileDir"`
	Host          string `json:"Host" xml:"Host"`
	ExpireTime    int64  `json:"ExpireTime" xml:"ExpireTime"`
	EncodedPolicy string `json:"EncodedPolicy" xml:"EncodedPolicy"`
	Min           int64  `json:"Min" xml:"Min"`
	Max           int64  `json:"Max" xml:"Max"`
	Encryption    string `json:"Encryption" xml:"Encryption"`
}

// CreateGenerateCompanyRegUploadPolicyRequest creates a request to invoke GenerateCompanyRegUploadPolicy API
func CreateGenerateCompanyRegUploadPolicyRequest() (request *GenerateCompanyRegUploadPolicyRequest) {
	request = &GenerateCompanyRegUploadPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "GenerateCompanyRegUploadPolicy", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenerateCompanyRegUploadPolicyResponse creates a response to parse from GenerateCompanyRegUploadPolicy response
func CreateGenerateCompanyRegUploadPolicyResponse() (response *GenerateCompanyRegUploadPolicyResponse) {
	response = &GenerateCompanyRegUploadPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
