package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckCompanyReg invokes the companyreg.CheckCompanyReg API synchronously
func (client *Client) CheckCompanyReg(request *CheckCompanyRegRequest) (response *CheckCompanyRegResponse, err error) {
	response = CreateCheckCompanyRegResponse()
	err = client.DoAction(request, response)
	return
}

// CheckCompanyRegWithChan invokes the companyreg.CheckCompanyReg API asynchronously
func (client *Client) CheckCompanyRegWithChan(request *CheckCompanyRegRequest) (<-chan *CheckCompanyRegResponse, <-chan error) {
	responseChan := make(chan *CheckCompanyRegResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckCompanyReg(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckCompanyRegWithCallback invokes the companyreg.CheckCompanyReg API asynchronously
func (client *Client) CheckCompanyRegWithCallback(request *CheckCompanyRegRequest, callback func(response *CheckCompanyRegResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckCompanyRegResponse
		var err error
		defer close(result)
		response, err = client.CheckCompanyReg(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckCompanyRegRequest is the request struct for api CheckCompanyReg
type CheckCompanyRegRequest struct {
	*requests.RpcRequest
	OrgType      string           `position:"Query" name:"OrgType"`
	IndustryType string           `position:"Query" name:"IndustryType"`
	TradeName    string           `position:"Query" name:"TradeName"`
	City         string           `position:"Query" name:"City"`
	NameType     requests.Integer `position:"Query" name:"NameType"`
}

// CheckCompanyRegResponse is the response struct for api CheckCompanyReg
type CheckCompanyRegResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	MatchCity        string           `json:"MatchCity" xml:"MatchCity"`
	MatchBrand       string           `json:"MatchBrand" xml:"MatchBrand"`
	MatchSensitive   string           `json:"MatchSensitive" xml:"MatchSensitive"`
	Level            string           `json:"Level" xml:"Level"`
	SimilarCompanies SimilarCompanies `json:"SimilarCompanies" xml:"SimilarCompanies"`
}

// CreateCheckCompanyRegRequest creates a request to invoke CheckCompanyReg API
func CreateCheckCompanyRegRequest() (request *CheckCompanyRegRequest) {
	request = &CheckCompanyRegRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "CheckCompanyReg", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckCompanyRegResponse creates a response to parse from CheckCompanyReg response
func CreateCheckCompanyRegResponse() (response *CheckCompanyRegResponse) {
	response = &CheckCompanyRegResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
