package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMetricLast invokes the cms.DescribeMetricLast API synchronously
func (client *Client) DescribeMetricLast(request *DescribeMetricLastRequest) (response *DescribeMetricLastResponse, err error) {
	response = CreateDescribeMetricLastResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMetricLastWithChan invokes the cms.DescribeMetricLast API asynchronously
func (client *Client) DescribeMetricLastWithChan(request *DescribeMetricLastRequest) (<-chan *DescribeMetricLastResponse, <-chan error) {
	responseChan := make(chan *DescribeMetricLastResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMetricLast(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMetricLastWithCallback invokes the cms.DescribeMetricLast API asynchronously
func (client *Client) DescribeMetricLastWithCallback(request *DescribeMetricLastRequest, callback func(response *DescribeMetricLastResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMetricLastResponse
		var err error
		defer close(result)
		response, err = client.DescribeMetricLast(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMetricLastRequest is the request struct for api DescribeMetricLast
type DescribeMetricLastRequest struct {
	*requests.RpcRequest
	Express    string `position:"Query" name:"Express"`
	StartTime  string `position:"Query" name:"StartTime"`
	NextToken  string `position:"Query" name:"NextToken"`
	MetricName string `position:"Query" name:"MetricName"`
	Period     string `position:"Query" name:"Period"`
	Length     string `position:"Query" name:"Length"`
	EndTime    string `position:"Query" name:"EndTime"`
	Namespace  string `position:"Query" name:"Namespace"`
	Dimensions string `position:"Query" name:"Dimensions"`
}

// DescribeMetricLastResponse is the response struct for api DescribeMetricLast
type DescribeMetricLastResponse struct {
	*responses.BaseResponse
	Code       string `json:"Code" xml:"Code"`
	Message    string `json:"Message" xml:"Message"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	NextToken  string `json:"NextToken" xml:"NextToken"`
	Datapoints string `json:"Datapoints" xml:"Datapoints"`
	Period     string `json:"Period" xml:"Period"`
	Success    bool   `json:"Success" xml:"Success"`
}

// CreateDescribeMetricLastRequest creates a request to invoke DescribeMetricLast API
func CreateDescribeMetricLastRequest() (request *DescribeMetricLastRequest) {
	request = &DescribeMetricLastRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeMetricLast", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMetricLastResponse creates a response to parse from DescribeMetricLast response
func CreateDescribeMetricLastResponse() (response *DescribeMetricLastResponse) {
	response = &DescribeMetricLastResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
