package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OemMarketingSettingData invokes the cloudwf.OemMarketingSettingData API synchronously
// api document: https://help.aliyun.com/api/cloudwf/oemmarketingsettingdata.html
func (client *Client) OemMarketingSettingData(request *OemMarketingSettingDataRequest) (response *OemMarketingSettingDataResponse, err error) {
	response = CreateOemMarketingSettingDataResponse()
	err = client.DoAction(request, response)
	return
}

// OemMarketingSettingDataWithChan invokes the cloudwf.OemMarketingSettingData API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemmarketingsettingdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemMarketingSettingDataWithChan(request *OemMarketingSettingDataRequest) (<-chan *OemMarketingSettingDataResponse, <-chan error) {
	responseChan := make(chan *OemMarketingSettingDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OemMarketingSettingData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OemMarketingSettingDataWithCallback invokes the cloudwf.OemMarketingSettingData API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemmarketingsettingdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemMarketingSettingDataWithCallback(request *OemMarketingSettingDataRequest, callback func(response *OemMarketingSettingDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OemMarketingSettingDataResponse
		var err error
		defer close(result)
		response, err = client.OemMarketingSettingData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OemMarketingSettingDataRequest is the request struct for api OemMarketingSettingData
type OemMarketingSettingDataRequest struct {
	*requests.RpcRequest
	Bid requests.Integer `position:"Query" name:"Bid"`
}

// OemMarketingSettingDataResponse is the response struct for api OemMarketingSettingData
type OemMarketingSettingDataResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateOemMarketingSettingDataRequest creates a request to invoke OemMarketingSettingData API
func CreateOemMarketingSettingDataRequest() (request *OemMarketingSettingDataRequest) {
	request = &OemMarketingSettingDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "OemMarketingSettingData", "cloudwf", "openAPI")
	return
}

// CreateOemMarketingSettingDataResponse creates a response to parse from OemMarketingSettingData response
func CreateOemMarketingSettingDataResponse() (response *OemMarketingSettingDataResponse) {
	response = &OemMarketingSettingDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
