package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CeaseInstance invokes the cloudwf.CeaseInstance API synchronously
// api document: https://help.aliyun.com/api/cloudwf/ceaseinstance.html
func (client *Client) CeaseInstance(request *CeaseInstanceRequest) (response *CeaseInstanceResponse, err error) {
	response = CreateCeaseInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CeaseInstanceWithChan invokes the cloudwf.CeaseInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/ceaseinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CeaseInstanceWithChan(request *CeaseInstanceRequest) (<-chan *CeaseInstanceResponse, <-chan error) {
	responseChan := make(chan *CeaseInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CeaseInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CeaseInstanceWithCallback invokes the cloudwf.CeaseInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/ceaseinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CeaseInstanceWithCallback(request *CeaseInstanceRequest, callback func(response *CeaseInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CeaseInstanceResponse
		var err error
		defer close(result)
		response, err = client.CeaseInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CeaseInstanceRequest is the request struct for api CeaseInstance
type CeaseInstanceRequest struct {
	*requests.RpcRequest
	TraceId string `position:"Query" name:"TraceId"`
	SpMsg   string `position:"Query" name:"SpMsg"`
}

// CeaseInstanceResponse is the response struct for api CeaseInstance
type CeaseInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"success" xml:"success"`
	Message   string `json:"message" xml:"message"`
	Result    string `json:"result" xml:"result"`
}

// CreateCeaseInstanceRequest creates a request to invoke CeaseInstance API
func CreateCeaseInstanceRequest() (request *CeaseInstanceRequest) {
	request = &CeaseInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "CeaseInstance", "cloudwf", "openAPI")
	return
}

// CreateCeaseInstanceResponse creates a response to parse from CeaseInstance response
func CreateCeaseInstanceResponse() (response *CeaseInstanceResponse) {
	response = &CeaseInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
