package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMaxInstances invokes the cloudcallcenter.GetMaxInstances API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getmaxinstances.html
func (client *Client) GetMaxInstances(request *GetMaxInstancesRequest) (response *GetMaxInstancesResponse, err error) {
	response = CreateGetMaxInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// GetMaxInstancesWithChan invokes the cloudcallcenter.GetMaxInstances API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getmaxinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMaxInstancesWithChan(request *GetMaxInstancesRequest) (<-chan *GetMaxInstancesResponse, <-chan error) {
	responseChan := make(chan *GetMaxInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMaxInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMaxInstancesWithCallback invokes the cloudcallcenter.GetMaxInstances API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getmaxinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMaxInstancesWithCallback(request *GetMaxInstancesRequest, callback func(response *GetMaxInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMaxInstancesResponse
		var err error
		defer close(result)
		response, err = client.GetMaxInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMaxInstancesRequest is the request struct for api GetMaxInstances
type GetMaxInstancesRequest struct {
	*requests.RpcRequest
}

// GetMaxInstancesResponse is the response struct for api GetMaxInstances
type GetMaxInstancesResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Count          int    `json:"Count" xml:"Count"`
}

// CreateGetMaxInstancesRequest creates a request to invoke GetMaxInstances API
func CreateGetMaxInstancesRequest() (request *GetMaxInstancesRequest) {
	request = &GetMaxInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetMaxInstances", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMaxInstancesResponse creates a response to parse from GetMaxInstances response
func CreateGetMaxInstancesResponse() (response *GetMaxInstancesResponse) {
	response = &GetMaxInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
