package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddFunctionMeta invokes the cloudcallcenter.AddFunctionMeta API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/addfunctionmeta.html
func (client *Client) AddFunctionMeta(request *AddFunctionMetaRequest) (response *AddFunctionMetaResponse, err error) {
	response = CreateAddFunctionMetaResponse()
	err = client.DoAction(request, response)
	return
}

// AddFunctionMetaWithChan invokes the cloudcallcenter.AddFunctionMeta API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/addfunctionmeta.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddFunctionMetaWithChan(request *AddFunctionMetaRequest) (<-chan *AddFunctionMetaResponse, <-chan error) {
	responseChan := make(chan *AddFunctionMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddFunctionMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddFunctionMetaWithCallback invokes the cloudcallcenter.AddFunctionMeta API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/addfunctionmeta.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddFunctionMetaWithCallback(request *AddFunctionMetaRequest, callback func(response *AddFunctionMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddFunctionMetaResponse
		var err error
		defer close(result)
		response, err = client.AddFunctionMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddFunctionMetaRequest is the request struct for api AddFunctionMeta
type AddFunctionMetaRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	Role         string `position:"Query" name:"Role"`
	Service      string `position:"Query" name:"Service"`
	FunctionName string `position:"Query" name:"FunctionName"`
	Description  string `position:"Query" name:"Description"`
	Region       string `position:"Query" name:"Region"`
}

// AddFunctionMetaResponse is the response struct for api AddFunctionMeta
type AddFunctionMetaResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	FunctionId     string `json:"FunctionId" xml:"FunctionId"`
}

// CreateAddFunctionMetaRequest creates a request to invoke AddFunctionMeta API
func CreateAddFunctionMetaRequest() (request *AddFunctionMetaRequest) {
	request = &AddFunctionMetaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "AddFunctionMeta", "", "")
	request.Method = requests.POST
	return
}

// CreateAddFunctionMetaResponse creates a response to parse from AddFunctionMeta response
func CreateAddFunctionMetaResponse() (response *AddFunctionMetaResponse) {
	response = &AddFunctionMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
