package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LivenessDetect invokes the cloudauth.LivenessDetect API synchronously
func (client *Client) LivenessDetect(request *LivenessDetectRequest) (response *LivenessDetectResponse, err error) {
	response = CreateLivenessDetectResponse()
	err = client.DoAction(request, response)
	return
}

// LivenessDetectWithChan invokes the cloudauth.LivenessDetect API asynchronously
func (client *Client) LivenessDetectWithChan(request *LivenessDetectRequest) (<-chan *LivenessDetectResponse, <-chan error) {
	responseChan := make(chan *LivenessDetectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LivenessDetect(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LivenessDetectWithCallback invokes the cloudauth.LivenessDetect API asynchronously
func (client *Client) LivenessDetectWithCallback(request *LivenessDetectRequest, callback func(response *LivenessDetectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LivenessDetectResponse
		var err error
		defer close(result)
		response, err = client.LivenessDetect(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LivenessDetectRequest is the request struct for api LivenessDetect
type LivenessDetectRequest struct {
	*requests.RpcRequest
	MediaCategory string `position:"Body" name:"MediaCategory"`
	MediaUrl      string `position:"Body" name:"MediaUrl"`
	BizType       string `position:"Body" name:"BizType"`
	BizId         string `position:"Body" name:"BizId"`
	MediaFile     string `position:"Body" name:"MediaFile"`
}

// LivenessDetectResponse is the response struct for api LivenessDetect
type LivenessDetectResponse struct {
	*responses.BaseResponse
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Success      bool         `json:"Success" xml:"Success"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateLivenessDetectRequest creates a request to invoke LivenessDetect API
func CreateLivenessDetectRequest() (request *LivenessDetectRequest) {
	request = &LivenessDetectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2020-11-12", "LivenessDetect", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateLivenessDetectResponse creates a response to parse from LivenessDetect response
func CreateLivenessDetectResponse() (response *LivenessDetectResponse) {
	response = &LivenessDetectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
