package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetStatus invokes the cloudauth.GetStatus API synchronously
func (client *Client) GetStatus(request *GetStatusRequest) (response *GetStatusResponse, err error) {
	response = CreateGetStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetStatusWithChan invokes the cloudauth.GetStatus API asynchronously
func (client *Client) GetStatusWithChan(request *GetStatusRequest) (<-chan *GetStatusResponse, <-chan error) {
	responseChan := make(chan *GetStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetStatusWithCallback invokes the cloudauth.GetStatus API asynchronously
func (client *Client) GetStatusWithCallback(request *GetStatusRequest, callback func(response *GetStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetStatusResponse
		var err error
		defer close(result)
		response, err = client.GetStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetStatusRequest is the request struct for api GetStatus
type GetStatusRequest struct {
	*requests.RpcRequest
	Biz      string `position:"Query" name:"Biz"`
	TicketId string `position:"Query" name:"TicketId"`
}

// GetStatusResponse is the response struct for api GetStatus
type GetStatusResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetStatusRequest creates a request to invoke GetStatus API
func CreateGetStatusRequest() (request *GetStatusRequest) {
	request = &GetStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2018-09-16", "GetStatus", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetStatusResponse creates a response to parse from GetStatus response
func CreateGetStatusResponse() (response *GetStatusResponse) {
	response = &GetStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
