package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPersonTag invokes the cdrs.ListPersonTag API synchronously
func (client *Client) ListPersonTag(request *ListPersonTagRequest) (response *ListPersonTagResponse, err error) {
	response = CreateListPersonTagResponse()
	err = client.DoAction(request, response)
	return
}

// ListPersonTagWithChan invokes the cdrs.ListPersonTag API asynchronously
func (client *Client) ListPersonTagWithChan(request *ListPersonTagRequest) (<-chan *ListPersonTagResponse, <-chan error) {
	responseChan := make(chan *ListPersonTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPersonTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPersonTagWithCallback invokes the cdrs.ListPersonTag API asynchronously
func (client *Client) ListPersonTagWithCallback(request *ListPersonTagRequest, callback func(response *ListPersonTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPersonTagResponse
		var err error
		defer close(result)
		response, err = client.ListPersonTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPersonTagRequest is the request struct for api ListPersonTag
type ListPersonTagRequest struct {
	*requests.RpcRequest
	Schema     string           `position:"Body" name:"Schema"`
	CorpId     string           `position:"Body" name:"CorpId"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	TagCode    string           `position:"Body" name:"TagCode"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
}

// ListPersonTagResponse is the response struct for api ListPersonTag
type ListPersonTagResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int64   `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64   `json:"PageSize" xml:"PageSize"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	Data       []Datas `json:"Data" xml:"Data"`
}

// CreateListPersonTagRequest creates a request to invoke ListPersonTag API
func CreateListPersonTagRequest() (request *ListPersonTagRequest) {
	request = &ListPersonTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "ListPersonTag", "", "")
	request.Method = requests.POST
	return
}

// CreateListPersonTagResponse creates a response to parse from ListPersonTag response
func CreateListPersonTagResponse() (response *ListPersonTagResponse) {
	response = &ListPersonTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
