package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCdnSubTask invokes the cdn.CreateCdnSubTask API synchronously
func (client *Client) CreateCdnSubTask(request *CreateCdnSubTaskRequest) (response *CreateCdnSubTaskResponse, err error) {
	response = CreateCreateCdnSubTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCdnSubTaskWithChan invokes the cdn.CreateCdnSubTask API asynchronously
func (client *Client) CreateCdnSubTaskWithChan(request *CreateCdnSubTaskRequest) (<-chan *CreateCdnSubTaskResponse, <-chan error) {
	responseChan := make(chan *CreateCdnSubTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCdnSubTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCdnSubTaskWithCallback invokes the cdn.CreateCdnSubTask API asynchronously
func (client *Client) CreateCdnSubTaskWithCallback(request *CreateCdnSubTaskRequest, callback func(response *CreateCdnSubTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCdnSubTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateCdnSubTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCdnSubTaskRequest is the request struct for api CreateCdnSubTask
type CreateCdnSubTaskRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Body" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	ReportIds  string           `position:"Body" name:"ReportIds"`
}

// CreateCdnSubTaskResponse is the response struct for api CreateCdnSubTask
type CreateCdnSubTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateCdnSubTaskRequest creates a request to invoke CreateCdnSubTask API
func CreateCreateCdnSubTaskRequest() (request *CreateCdnSubTaskRequest) {
	request = &CreateCdnSubTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "CreateCdnSubTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateCdnSubTaskResponse creates a response to parse from CreateCdnSubTask response
func CreateCreateCdnSubTaskResponse() (response *CreateCdnSubTaskResponse) {
	response = &CreateCdnSubTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
