package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCallDetailRecords invokes the ccc.ListCallDetailRecords API synchronously
func (client *Client) ListCallDetailRecords(request *ListCallDetailRecordsRequest) (response *ListCallDetailRecordsResponse, err error) {
	response = CreateListCallDetailRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// ListCallDetailRecordsWithChan invokes the ccc.ListCallDetailRecords API asynchronously
func (client *Client) ListCallDetailRecordsWithChan(request *ListCallDetailRecordsRequest) (<-chan *ListCallDetailRecordsResponse, <-chan error) {
	responseChan := make(chan *ListCallDetailRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCallDetailRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCallDetailRecordsWithCallback invokes the ccc.ListCallDetailRecords API asynchronously
func (client *Client) ListCallDetailRecordsWithCallback(request *ListCallDetailRecordsRequest, callback func(response *ListCallDetailRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCallDetailRecordsResponse
		var err error
		defer close(result)
		response, err = client.ListCallDetailRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCallDetailRecordsRequest is the request struct for api ListCallDetailRecords
type ListCallDetailRecordsRequest struct {
	*requests.RpcRequest
	ContactId                   string           `position:"Query" name:"ContactId"`
	Criteria                    string           `position:"Query" name:"Criteria"`
	OrderByField                string           `position:"Query" name:"OrderByField"`
	StartTime                   requests.Integer `position:"Query" name:"StartTime"`
	PageNumber                  requests.Integer `position:"Query" name:"PageNumber"`
	CalledNumber                string           `position:"Query" name:"CalledNumber"`
	SatisfactionList            string           `position:"Query" name:"SatisfactionList"`
	PageSize                    requests.Integer `position:"Query" name:"PageSize"`
	SortOrder                   string           `position:"Query" name:"SortOrder"`
	SatisfactionDescriptionList string           `position:"Query" name:"SatisfactionDescriptionList"`
	AgentId                     string           `position:"Query" name:"AgentId"`
	ContactType                 string           `position:"Query" name:"ContactType"`
	SatisfactionSurveyChannel   string           `position:"Query" name:"SatisfactionSurveyChannel"`
	EndTime                     requests.Integer `position:"Query" name:"EndTime"`
	CallingNumber               string           `position:"Query" name:"CallingNumber"`
	ContactDisposition          string           `position:"Query" name:"ContactDisposition"`
	InstanceId                  string           `position:"Query" name:"InstanceId"`
	SkillGroupId                string           `position:"Query" name:"SkillGroupId"`
}

// ListCallDetailRecordsResponse is the response struct for api ListCallDetailRecords
type ListCallDetailRecordsResponse struct {
	*responses.BaseResponse
	Code           string                      `json:"Code" xml:"Code"`
	HttpStatusCode int                         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                      `json:"Message" xml:"Message"`
	RequestId      string                      `json:"RequestId" xml:"RequestId"`
	Data           DataInListCallDetailRecords `json:"Data" xml:"Data"`
}

// CreateListCallDetailRecordsRequest creates a request to invoke ListCallDetailRecords API
func CreateListCallDetailRecordsRequest() (request *ListCallDetailRecordsRequest) {
	request = &ListCallDetailRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListCallDetailRecords", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListCallDetailRecordsResponse creates a response to parse from ListCallDetailRecords response
func CreateListCallDetailRecordsResponse() (response *ListCallDetailRecordsResponse) {
	response = &ListCallDetailRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
