package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSSLCertificateWithName invokes the cas.CreateSSLCertificateWithName API synchronously
func (client *Client) CreateSSLCertificateWithName(request *CreateSSLCertificateWithNameRequest) (response *CreateSSLCertificateWithNameResponse, err error) {
	response = CreateCreateSSLCertificateWithNameResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSSLCertificateWithNameWithChan invokes the cas.CreateSSLCertificateWithName API asynchronously
func (client *Client) CreateSSLCertificateWithNameWithChan(request *CreateSSLCertificateWithNameRequest) (<-chan *CreateSSLCertificateWithNameResponse, <-chan error) {
	responseChan := make(chan *CreateSSLCertificateWithNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSSLCertificateWithName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSSLCertificateWithNameWithCallback invokes the cas.CreateSSLCertificateWithName API asynchronously
func (client *Client) CreateSSLCertificateWithNameWithCallback(request *CreateSSLCertificateWithNameRequest, callback func(response *CreateSSLCertificateWithNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSSLCertificateWithNameResponse
		var err error
		defer close(result)
		response, err = client.CreateSSLCertificateWithName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSSLCertificateWithNameRequest is the request struct for api CreateSSLCertificateWithName
type CreateSSLCertificateWithNameRequest struct {
	*requests.RpcRequest
	Certificate string `position:"Query" name:"Certificate"`
	PrivateKey  string `position:"Query" name:"PrivateKey"`
	SourceIp    string `position:"Query" name:"SourceIp"`
	CertName    string `position:"Query" name:"CertName"`
}

// CreateSSLCertificateWithNameResponse is the response struct for api CreateSSLCertificateWithName
type CreateSSLCertificateWithNameResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	CertIdentifier string `json:"CertIdentifier" xml:"CertIdentifier"`
}

// CreateCreateSSLCertificateWithNameRequest creates a request to invoke CreateSSLCertificateWithName API
func CreateCreateSSLCertificateWithNameRequest() (request *CreateSSLCertificateWithNameRequest) {
	request = &CreateSSLCertificateWithNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-06-19", "CreateSSLCertificateWithName", "cas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSSLCertificateWithNameResponse creates a response to parse from CreateSSLCertificateWithName response
func CreateCreateSSLCertificateWithNameResponse() (response *CreateSSLCertificateWithNameResponse) {
	response = &CreateSSLCertificateWithNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
