package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSavingsPlansUsageDetail invokes the bssopenapi.DescribeSavingsPlansUsageDetail API synchronously
func (client *Client) DescribeSavingsPlansUsageDetail(request *DescribeSavingsPlansUsageDetailRequest) (response *DescribeSavingsPlansUsageDetailResponse, err error) {
	response = CreateDescribeSavingsPlansUsageDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSavingsPlansUsageDetailWithChan invokes the bssopenapi.DescribeSavingsPlansUsageDetail API asynchronously
func (client *Client) DescribeSavingsPlansUsageDetailWithChan(request *DescribeSavingsPlansUsageDetailRequest) (<-chan *DescribeSavingsPlansUsageDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeSavingsPlansUsageDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSavingsPlansUsageDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSavingsPlansUsageDetailWithCallback invokes the bssopenapi.DescribeSavingsPlansUsageDetail API asynchronously
func (client *Client) DescribeSavingsPlansUsageDetailWithCallback(request *DescribeSavingsPlansUsageDetailRequest, callback func(response *DescribeSavingsPlansUsageDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSavingsPlansUsageDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeSavingsPlansUsageDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSavingsPlansUsageDetailRequest is the request struct for api DescribeSavingsPlansUsageDetail
type DescribeSavingsPlansUsageDetailRequest struct {
	*requests.RpcRequest
	PeriodType  string           `position:"Query" name:"PeriodType"`
	BillOwnerId requests.Integer `position:"Query" name:"BillOwnerId"`
	StartPeriod string           `position:"Query" name:"StartPeriod"`
	EndPeriod   string           `position:"Query" name:"EndPeriod"`
	Token       string           `position:"Query" name:"Token"`
	MaxResults  requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeSavingsPlansUsageDetailResponse is the response struct for api DescribeSavingsPlansUsageDetail
type DescribeSavingsPlansUsageDetailResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeSavingsPlansUsageDetailRequest creates a request to invoke DescribeSavingsPlansUsageDetail API
func CreateDescribeSavingsPlansUsageDetailRequest() (request *DescribeSavingsPlansUsageDetailRequest) {
	request = &DescribeSavingsPlansUsageDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "DescribeSavingsPlansUsageDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSavingsPlansUsageDetailResponse creates a response to parse from DescribeSavingsPlansUsageDetail response
func CreateDescribeSavingsPlansUsageDetailResponse() (response *DescribeSavingsPlansUsageDetailResponse) {
	response = &DescribeSavingsPlansUsageDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
