package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePrometheusAlertRule invokes the arms.UpdatePrometheusAlertRule API synchronously
func (client *Client) UpdatePrometheusAlertRule(request *UpdatePrometheusAlertRuleRequest) (response *UpdatePrometheusAlertRuleResponse, err error) {
	response = CreateUpdatePrometheusAlertRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePrometheusAlertRuleWithChan invokes the arms.UpdatePrometheusAlertRule API asynchronously
func (client *Client) UpdatePrometheusAlertRuleWithChan(request *UpdatePrometheusAlertRuleRequest) (<-chan *UpdatePrometheusAlertRuleResponse, <-chan error) {
	responseChan := make(chan *UpdatePrometheusAlertRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePrometheusAlertRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePrometheusAlertRuleWithCallback invokes the arms.UpdatePrometheusAlertRule API asynchronously
func (client *Client) UpdatePrometheusAlertRuleWithCallback(request *UpdatePrometheusAlertRuleRequest, callback func(response *UpdatePrometheusAlertRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePrometheusAlertRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdatePrometheusAlertRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePrometheusAlertRuleRequest is the request struct for api UpdatePrometheusAlertRule
type UpdatePrometheusAlertRuleRequest struct {
	*requests.RpcRequest
	Expression     string           `position:"Query" name:"Expression"`
	AlertName      string           `position:"Query" name:"AlertName"`
	Annotations    string           `position:"Query" name:"Annotations"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	DispatchRuleId requests.Integer `position:"Query" name:"DispatchRuleId"`
	ProxyUserId    string           `position:"Query" name:"ProxyUserId"`
	Type           string           `position:"Query" name:"Type"`
	Message        string           `position:"Query" name:"Message"`
	Labels         string           `position:"Query" name:"Labels"`
	Duration       string           `position:"Query" name:"Duration"`
	AlertId        requests.Integer `position:"Query" name:"AlertId"`
	NotifyType     string           `position:"Query" name:"NotifyType"`
}

// UpdatePrometheusAlertRuleResponse is the response struct for api UpdatePrometheusAlertRule
type UpdatePrometheusAlertRuleResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	PrometheusAlertRule PrometheusAlertRule `json:"PrometheusAlertRule" xml:"PrometheusAlertRule"`
}

// CreateUpdatePrometheusAlertRuleRequest creates a request to invoke UpdatePrometheusAlertRule API
func CreateUpdatePrometheusAlertRuleRequest() (request *UpdatePrometheusAlertRuleRequest) {
	request = &UpdatePrometheusAlertRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "UpdatePrometheusAlertRule", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdatePrometheusAlertRuleResponse creates a response to parse from UpdatePrometheusAlertRule response
func CreateUpdatePrometheusAlertRuleResponse() (response *UpdatePrometheusAlertRuleResponse) {
	response = &UpdatePrometheusAlertRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
