package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportAppAlertRules invokes the arms.ImportAppAlertRules API synchronously
func (client *Client) ImportAppAlertRules(request *ImportAppAlertRulesRequest) (response *ImportAppAlertRulesResponse, err error) {
	response = CreateImportAppAlertRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ImportAppAlertRulesWithChan invokes the arms.ImportAppAlertRules API asynchronously
func (client *Client) ImportAppAlertRulesWithChan(request *ImportAppAlertRulesRequest) (<-chan *ImportAppAlertRulesResponse, <-chan error) {
	responseChan := make(chan *ImportAppAlertRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportAppAlertRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportAppAlertRulesWithCallback invokes the arms.ImportAppAlertRules API asynchronously
func (client *Client) ImportAppAlertRulesWithCallback(request *ImportAppAlertRulesRequest, callback func(response *ImportAppAlertRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportAppAlertRulesResponse
		var err error
		defer close(result)
		response, err = client.ImportAppAlertRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportAppAlertRulesRequest is the request struct for api ImportAppAlertRules
type ImportAppAlertRulesRequest struct {
	*requests.RpcRequest
	IsAutoStart         requests.Boolean `position:"Query" name:"IsAutoStart"`
	ProxyUserId         string           `position:"Query" name:"ProxyUserId"`
	ContactGroupIds     string           `position:"Query" name:"ContactGroupIds"`
	Pids                string           `position:"Query" name:"Pids"`
	TemplageAlertConfig string           `position:"Query" name:"TemplageAlertConfig"`
	TemplateAlertId     string           `position:"Query" name:"TemplateAlertId"`
}

// ImportAppAlertRulesResponse is the response struct for api ImportAppAlertRules
type ImportAppAlertRulesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateImportAppAlertRulesRequest creates a request to invoke ImportAppAlertRules API
func CreateImportAppAlertRulesRequest() (request *ImportAppAlertRulesRequest) {
	request = &ImportAppAlertRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ImportAppAlertRules", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImportAppAlertRulesResponse creates a response to parse from ImportAppAlertRules response
func CreateImportAppAlertRulesResponse() (response *ImportAppAlertRulesResponse) {
	response = &ImportAppAlertRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
