package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAlertContactGroup invokes the arms.DeleteAlertContactGroup API synchronously
func (client *Client) DeleteAlertContactGroup(request *DeleteAlertContactGroupRequest) (response *DeleteAlertContactGroupResponse, err error) {
	response = CreateDeleteAlertContactGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAlertContactGroupWithChan invokes the arms.DeleteAlertContactGroup API asynchronously
func (client *Client) DeleteAlertContactGroupWithChan(request *DeleteAlertContactGroupRequest) (<-chan *DeleteAlertContactGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteAlertContactGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAlertContactGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAlertContactGroupWithCallback invokes the arms.DeleteAlertContactGroup API asynchronously
func (client *Client) DeleteAlertContactGroupWithCallback(request *DeleteAlertContactGroupRequest, callback func(response *DeleteAlertContactGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAlertContactGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteAlertContactGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAlertContactGroupRequest is the request struct for api DeleteAlertContactGroup
type DeleteAlertContactGroupRequest struct {
	*requests.RpcRequest
	ContactGroupId requests.Integer `position:"Query" name:"ContactGroupId"`
	ProxyUserId    string           `position:"Query" name:"ProxyUserId"`
}

// DeleteAlertContactGroupResponse is the response struct for api DeleteAlertContactGroup
type DeleteAlertContactGroupResponse struct {
	*responses.BaseResponse
	RequestId                        string `json:"RequestId" xml:"RequestId"`
	DeleteAlertContactGroupIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
}

// CreateDeleteAlertContactGroupRequest creates a request to invoke DeleteAlertContactGroup API
func CreateDeleteAlertContactGroupRequest() (request *DeleteAlertContactGroupRequest) {
	request = &DeleteAlertContactGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "DeleteAlertContactGroup", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAlertContactGroupResponse creates a response to parse from DeleteAlertContactGroup response
func CreateDeleteAlertContactGroupResponse() (response *DeleteAlertContactGroupResponse) {
	response = &DeleteAlertContactGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
