package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDashboardMetricsFlows invokes the airec.ListDashboardMetricsFlows API synchronously
func (client *Client) ListDashboardMetricsFlows(request *ListDashboardMetricsFlowsRequest) (response *ListDashboardMetricsFlowsResponse, err error) {
	response = CreateListDashboardMetricsFlowsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDashboardMetricsFlowsWithChan invokes the airec.ListDashboardMetricsFlows API asynchronously
func (client *Client) ListDashboardMetricsFlowsWithChan(request *ListDashboardMetricsFlowsRequest) (<-chan *ListDashboardMetricsFlowsResponse, <-chan error) {
	responseChan := make(chan *ListDashboardMetricsFlowsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDashboardMetricsFlows(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDashboardMetricsFlowsWithCallback invokes the airec.ListDashboardMetricsFlows API asynchronously
func (client *Client) ListDashboardMetricsFlowsWithCallback(request *ListDashboardMetricsFlowsRequest, callback func(response *ListDashboardMetricsFlowsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDashboardMetricsFlowsResponse
		var err error
		defer close(result)
		response, err = client.ListDashboardMetricsFlows(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDashboardMetricsFlowsRequest is the request struct for api ListDashboardMetricsFlows
type ListDashboardMetricsFlowsRequest struct {
	*requests.RoaRequest
	MetricType string           `position:"Query" name:"metricType"`
	InstanceId string           `position:"Path" name:"instanceId"`
	EndTime    requests.Integer `position:"Query" name:"endTime"`
	StartTime  requests.Integer `position:"Query" name:"startTime"`
}

// ListDashboardMetricsFlowsResponse is the response struct for api ListDashboardMetricsFlows
type ListDashboardMetricsFlowsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"requestId" xml:"requestId"`
	Code      string       `json:"code" xml:"code"`
	Message   string       `json:"message" xml:"message"`
	Result    []ResultItem `json:"result" xml:"result"`
}

// CreateListDashboardMetricsFlowsRequest creates a request to invoke ListDashboardMetricsFlows API
func CreateListDashboardMetricsFlowsRequest() (request *ListDashboardMetricsFlowsRequest) {
	request = &ListDashboardMetricsFlowsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "ListDashboardMetricsFlows", "/v2/openapi/instances/[instanceId]/dashboard/metrics/flows", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDashboardMetricsFlowsResponse creates a response to parse from ListDashboardMetricsFlows response
func CreateListDashboardMetricsFlowsResponse() (response *ListDashboardMetricsFlowsResponse) {
	response = &ListDashboardMetricsFlowsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
