package afs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEarlyWarning invokes the afs.DescribeEarlyWarning API synchronously
// api document: https://help.aliyun.com/api/afs/describeearlywarning.html
func (client *Client) DescribeEarlyWarning(request *DescribeEarlyWarningRequest) (response *DescribeEarlyWarningResponse, err error) {
	response = CreateDescribeEarlyWarningResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEarlyWarningWithChan invokes the afs.DescribeEarlyWarning API asynchronously
// api document: https://help.aliyun.com/api/afs/describeearlywarning.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEarlyWarningWithChan(request *DescribeEarlyWarningRequest) (<-chan *DescribeEarlyWarningResponse, <-chan error) {
	responseChan := make(chan *DescribeEarlyWarningResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEarlyWarning(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEarlyWarningWithCallback invokes the afs.DescribeEarlyWarning API asynchronously
// api document: https://help.aliyun.com/api/afs/describeearlywarning.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEarlyWarningWithCallback(request *DescribeEarlyWarningRequest, callback func(response *DescribeEarlyWarningResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEarlyWarningResponse
		var err error
		defer close(result)
		response, err = client.DescribeEarlyWarning(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEarlyWarningRequest is the request struct for api DescribeEarlyWarning
type DescribeEarlyWarningRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeEarlyWarningResponse is the response struct for api DescribeEarlyWarning
type DescribeEarlyWarningResponse struct {
	*responses.BaseResponse
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	HasWarning    bool           `json:"HasWarning" xml:"HasWarning"`
	BizCode       string         `json:"BizCode" xml:"BizCode"`
	EarlyWarnings []EarlyWarning `json:"EarlyWarnings" xml:"EarlyWarnings"`
}

// CreateDescribeEarlyWarningRequest creates a request to invoke DescribeEarlyWarning API
func CreateDescribeEarlyWarningRequest() (request *DescribeEarlyWarningRequest) {
	request = &DescribeEarlyWarningRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("afs", "2018-01-12", "DescribeEarlyWarning", "afs", "openAPI")
	return
}

// CreateDescribeEarlyWarningResponse creates a response to parse from DescribeEarlyWarning response
func CreateDescribeEarlyWarningResponse() (response *DescribeEarlyWarningResponse) {
	response = &DescribeEarlyWarningResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
