package address_purification

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExtractExpress invokes the address_purification.ExtractExpress API synchronously
func (client *Client) ExtractExpress(request *ExtractExpressRequest) (response *ExtractExpressResponse, err error) {
	response = CreateExtractExpressResponse()
	err = client.DoAction(request, response)
	return
}

// ExtractExpressWithChan invokes the address_purification.ExtractExpress API asynchronously
func (client *Client) ExtractExpressWithChan(request *ExtractExpressRequest) (<-chan *ExtractExpressResponse, <-chan error) {
	responseChan := make(chan *ExtractExpressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExtractExpress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExtractExpressWithCallback invokes the address_purification.ExtractExpress API asynchronously
func (client *Client) ExtractExpressWithCallback(request *ExtractExpressRequest, callback func(response *ExtractExpressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExtractExpressResponse
		var err error
		defer close(result)
		response, err = client.ExtractExpress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExtractExpressRequest is the request struct for api ExtractExpress
type ExtractExpressRequest struct {
	*requests.RpcRequest
	DefaultProvince string `position:"Body" name:"DefaultProvince"`
	ServiceCode     string `position:"Body" name:"ServiceCode"`
	DefaultCity     string `position:"Body" name:"DefaultCity"`
	DefaultDistrict string `position:"Body" name:"DefaultDistrict"`
	AppKey          string `position:"Body" name:"AppKey"`
	Text            string `position:"Body" name:"Text"`
}

// ExtractExpressResponse is the response struct for api ExtractExpress
type ExtractExpressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateExtractExpressRequest creates a request to invoke ExtractExpress API
func CreateExtractExpressRequest() (request *ExtractExpressRequest) {
	request = &ExtractExpressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("address-purification", "2019-11-18", "ExtractExpress", "addrp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExtractExpressResponse creates a response to parse from ExtractExpress response
func CreateExtractExpressResponse() (response *ExtractExpressResponse) {
	response = &ExtractExpressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
