package monitoring

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/synapse/2019-11-01-preview/monitoring"

// SparkJob ...
type SparkJob struct {
	State              *string     `json:"state,omitempty"`
	Name               *string     `json:"name,omitempty"`
	Submitter          *string     `json:"submitter,omitempty"`
	Compute            *string     `json:"compute,omitempty"`
	SparkApplicationID *string     `json:"sparkApplicationId,omitempty"`
	LivyID             *string     `json:"livyId,omitempty"`
	Timing             *[]string   `json:"timing,omitempty"`
	SparkJobDefinition *string     `json:"sparkJobDefinition,omitempty"`
	Pipeline           *[]SparkJob `json:"pipeline,omitempty"`
	JobType            *string     `json:"jobType,omitempty"`
	SubmitTime         *date.Time  `json:"submitTime,omitempty"`
	EndTime            *date.Time  `json:"endTime,omitempty"`
	QueuedDuration     *string     `json:"queuedDuration,omitempty"`
	RunningDuration    *string     `json:"runningDuration,omitempty"`
	TotalDuration      *string     `json:"totalDuration,omitempty"`
}

// SparkJobListViewResponse ...
type SparkJobListViewResponse struct {
	autorest.Response `json:"-"`
	NJobs             *int32      `json:"nJobs,omitempty"`
	SparkJobs         *[]SparkJob `json:"sparkJobs,omitempty"`
}

// SQLQueryStringDataModel ...
type SQLQueryStringDataModel struct {
	autorest.Response `json:"-"`
	Query             *string `json:"query,omitempty"`
}
