// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package mediatailoriface provides an interface to enable mocking the AWS MediaTailor service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package mediatailoriface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/mediatailor"
)

// MediaTailorAPI provides an interface to enable mocking the
// mediatailor.MediaTailor service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS MediaTailor.
//    func myFunc(svc mediatailoriface.MediaTailorAPI) bool {
//        // Make svc.DeletePlaybackConfiguration request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := mediatailor.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockMediaTailorClient struct {
//        mediatailoriface.MediaTailorAPI
//    }
//    func (m *mockMediaTailorClient) DeletePlaybackConfiguration(input *mediatailor.DeletePlaybackConfigurationInput) (*mediatailor.DeletePlaybackConfigurationOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockMediaTailorClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type MediaTailorAPI interface {
	DeletePlaybackConfiguration(*mediatailor.DeletePlaybackConfigurationInput) (*mediatailor.DeletePlaybackConfigurationOutput, error)
	DeletePlaybackConfigurationWithContext(aws.Context, *mediatailor.DeletePlaybackConfigurationInput, ...request.Option) (*mediatailor.DeletePlaybackConfigurationOutput, error)
	DeletePlaybackConfigurationRequest(*mediatailor.DeletePlaybackConfigurationInput) (*request.Request, *mediatailor.DeletePlaybackConfigurationOutput)

	GetPlaybackConfiguration(*mediatailor.GetPlaybackConfigurationInput) (*mediatailor.GetPlaybackConfigurationOutput, error)
	GetPlaybackConfigurationWithContext(aws.Context, *mediatailor.GetPlaybackConfigurationInput, ...request.Option) (*mediatailor.GetPlaybackConfigurationOutput, error)
	GetPlaybackConfigurationRequest(*mediatailor.GetPlaybackConfigurationInput) (*request.Request, *mediatailor.GetPlaybackConfigurationOutput)

	ListPlaybackConfigurations(*mediatailor.ListPlaybackConfigurationsInput) (*mediatailor.ListPlaybackConfigurationsOutput, error)
	ListPlaybackConfigurationsWithContext(aws.Context, *mediatailor.ListPlaybackConfigurationsInput, ...request.Option) (*mediatailor.ListPlaybackConfigurationsOutput, error)
	ListPlaybackConfigurationsRequest(*mediatailor.ListPlaybackConfigurationsInput) (*request.Request, *mediatailor.ListPlaybackConfigurationsOutput)

	ListPlaybackConfigurationsPages(*mediatailor.ListPlaybackConfigurationsInput, func(*mediatailor.ListPlaybackConfigurationsOutput, bool) bool) error
	ListPlaybackConfigurationsPagesWithContext(aws.Context, *mediatailor.ListPlaybackConfigurationsInput, func(*mediatailor.ListPlaybackConfigurationsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*mediatailor.ListTagsForResourceInput) (*mediatailor.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *mediatailor.ListTagsForResourceInput, ...request.Option) (*mediatailor.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*mediatailor.ListTagsForResourceInput) (*request.Request, *mediatailor.ListTagsForResourceOutput)

	PutPlaybackConfiguration(*mediatailor.PutPlaybackConfigurationInput) (*mediatailor.PutPlaybackConfigurationOutput, error)
	PutPlaybackConfigurationWithContext(aws.Context, *mediatailor.PutPlaybackConfigurationInput, ...request.Option) (*mediatailor.PutPlaybackConfigurationOutput, error)
	PutPlaybackConfigurationRequest(*mediatailor.PutPlaybackConfigurationInput) (*request.Request, *mediatailor.PutPlaybackConfigurationOutput)

	TagResource(*mediatailor.TagResourceInput) (*mediatailor.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *mediatailor.TagResourceInput, ...request.Option) (*mediatailor.TagResourceOutput, error)
	TagResourceRequest(*mediatailor.TagResourceInput) (*request.Request, *mediatailor.TagResourceOutput)

	UntagResource(*mediatailor.UntagResourceInput) (*mediatailor.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *mediatailor.UntagResourceInput, ...request.Option) (*mediatailor.UntagResourceOutput, error)
	UntagResourceRequest(*mediatailor.UntagResourceInput) (*request.Request, *mediatailor.UntagResourceOutput)
}

var _ MediaTailorAPI = (*mediatailor.MediaTailor)(nil)
