// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/openshift/api/sharedresource/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SharedSecretLister helps list SharedSecrets.
// All objects returned here must be treated as read-only.
type SharedSecretLister interface {
	// List lists all SharedSecrets in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.SharedSecret, err error)
	// Get retrieves the SharedSecret from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.SharedSecret, error)
	SharedSecretListerExpansion
}

// sharedSecretLister implements the SharedSecretLister interface.
type sharedSecretLister struct {
	indexer cache.Indexer
}

// NewSharedSecretLister returns a new SharedSecretLister.
func NewSharedSecretLister(indexer cache.Indexer) SharedSecretLister {
	return &sharedSecretLister{indexer: indexer}
}

// List lists all SharedSecrets in the indexer.
func (s *sharedSecretLister) List(selector labels.Selector) (ret []*v1alpha1.SharedSecret, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.SharedSecret))
	})
	return ret, err
}

// Get retrieves the SharedSecret from the index for a given name.
func (s *sharedSecretLister) Get(name string) (*v1alpha1.SharedSecret, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("sharedsecret"), name)
	}
	return obj.(*v1alpha1.SharedSecret), nil
}
