// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/openshift/api/sharedresource/v1alpha1"
	scheme "github.com/openshift/client-go/sharedresource/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// SharedConfigMapsGetter has a method to return a SharedConfigMapInterface.
// A group's client should implement this interface.
type SharedConfigMapsGetter interface {
	SharedConfigMaps() SharedConfigMapInterface
}

// SharedConfigMapInterface has methods to work with SharedConfigMap resources.
type SharedConfigMapInterface interface {
	Create(ctx context.Context, sharedConfigMap *v1alpha1.SharedConfigMap, opts v1.CreateOptions) (*v1alpha1.SharedConfigMap, error)
	Update(ctx context.Context, sharedConfigMap *v1alpha1.SharedConfigMap, opts v1.UpdateOptions) (*v1alpha1.SharedConfigMap, error)
	UpdateStatus(ctx context.Context, sharedConfigMap *v1alpha1.SharedConfigMap, opts v1.UpdateOptions) (*v1alpha1.SharedConfigMap, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.SharedConfigMap, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.SharedConfigMapList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.SharedConfigMap, err error)
	SharedConfigMapExpansion
}

// sharedConfigMaps implements SharedConfigMapInterface
type sharedConfigMaps struct {
	client rest.Interface
}

// newSharedConfigMaps returns a SharedConfigMaps
func newSharedConfigMaps(c *SharedresourceV1alpha1Client) *sharedConfigMaps {
	return &sharedConfigMaps{
		client: c.RESTClient(),
	}
}

// Get takes name of the sharedConfigMap, and returns the corresponding sharedConfigMap object, and an error if there is any.
func (c *sharedConfigMaps) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.SharedConfigMap, err error) {
	result = &v1alpha1.SharedConfigMap{}
	err = c.client.Get().
		Resource("sharedconfigmaps").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of SharedConfigMaps that match those selectors.
func (c *sharedConfigMaps) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.SharedConfigMapList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.SharedConfigMapList{}
	err = c.client.Get().
		Resource("sharedconfigmaps").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested sharedConfigMaps.
func (c *sharedConfigMaps) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("sharedconfigmaps").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a sharedConfigMap and creates it.  Returns the server's representation of the sharedConfigMap, and an error, if there is any.
func (c *sharedConfigMaps) Create(ctx context.Context, sharedConfigMap *v1alpha1.SharedConfigMap, opts v1.CreateOptions) (result *v1alpha1.SharedConfigMap, err error) {
	result = &v1alpha1.SharedConfigMap{}
	err = c.client.Post().
		Resource("sharedconfigmaps").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sharedConfigMap).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a sharedConfigMap and updates it. Returns the server's representation of the sharedConfigMap, and an error, if there is any.
func (c *sharedConfigMaps) Update(ctx context.Context, sharedConfigMap *v1alpha1.SharedConfigMap, opts v1.UpdateOptions) (result *v1alpha1.SharedConfigMap, err error) {
	result = &v1alpha1.SharedConfigMap{}
	err = c.client.Put().
		Resource("sharedconfigmaps").
		Name(sharedConfigMap.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sharedConfigMap).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *sharedConfigMaps) UpdateStatus(ctx context.Context, sharedConfigMap *v1alpha1.SharedConfigMap, opts v1.UpdateOptions) (result *v1alpha1.SharedConfigMap, err error) {
	result = &v1alpha1.SharedConfigMap{}
	err = c.client.Put().
		Resource("sharedconfigmaps").
		Name(sharedConfigMap.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(sharedConfigMap).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the sharedConfigMap and deletes it. Returns an error if one occurs.
func (c *sharedConfigMaps) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("sharedconfigmaps").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *sharedConfigMaps) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("sharedconfigmaps").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched sharedConfigMap.
func (c *sharedConfigMaps) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.SharedConfigMap, err error) {
	result = &v1alpha1.SharedConfigMap{}
	err = c.client.Patch(pt).
		Resource("sharedconfigmaps").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
