#!/bin/bash

# This script generates a SAMToolkit.devenv, which is ignored by git.  You probably want to use your
# personal aws account for dev testing.

echo "Enter account number to deploy to: "
read SAM_ACCOUNT
echo ""

echo "Enter SAM isengard role name (create a role in isengard for your aws account): (empty for SAMDeployer) "
read SAM_ISENGARD_ROLE_NAME
echo ""
SAM_ISENGARD_ROLE_NAME="${SAM_ISENGARD_ROLE_NAME:-SAMDeployer}"

echo "Enter region for SAM account: (empty for us-west-2)"
read SAM_REGION
echo ""
SAM_REGION=${SAM_REGION:-"us-west-2"}

FILE=SAMToolkit.devenv

cat > $FILE <<- EOM
### Autogenerated from gen-sam-env ###

# Identity to use when publishing with SAM
AWS_ACCOUNT_ID="${SAM_ACCOUNT}"
SAM_ASSUME_ACCOUNT_ID="${SAM_ACCOUNT}"
SAM_ISENGARD_ROLE_NAME="${SAM_ISENGARD_ROLE_NAME}"

# What region to deploy to
SAM_REGION=\${SAM_REGION:-"${SAM_REGION}"}

# Cloudformation stack name that will be created on deploy
SAM_STACK=\${SAM_STACK:-"sam-dev-\${USER}-\$(basename \$(pwd))"}

# The S3 bucket used to store code archives (auto-created).
SAM_BUCKET="sam-dev-\${SAM_REGION}-\${USER}-\${SAM_ASSUME_ACCOUNT_ID}"

# The BATS transformer and publisher to use on 'sam package'
SAM_TRANSFORMER="DockerImage-1.0"
SAM_PUBLISHER="ECR-1.0"

# ECR repository to publish to
SAM_REPOSITORY_NAME="sam-dev-\${USER}"
# Tag for image. If this is removed, a random tag will be created. In pipelines,
# the build number is used
SAM_IMAGE_TAG="pod-identity-webhook_latest-\${USER}"

# The packages to use for the BATS transformation:
SAM_TARGET_PKG="AWSEKSPodIdentityWebhook-1.0"
SAM_PARAM_PKG="AWSEKSPodIdentityWebhook-1.0"


EOM
