// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package workload

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// SpiffeWorkloadAPIClient is the client API for SpiffeWorkloadAPI service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SpiffeWorkloadAPIClient interface {
	// JWT-SVID Profile
	FetchJWTSVID(ctx context.Context, in *JWTSVIDRequest, opts ...grpc.CallOption) (*JWTSVIDResponse, error)
	FetchJWTBundles(ctx context.Context, in *JWTBundlesRequest, opts ...grpc.CallOption) (SpiffeWorkloadAPI_FetchJWTBundlesClient, error)
	ValidateJWTSVID(ctx context.Context, in *ValidateJWTSVIDRequest, opts ...grpc.CallOption) (*ValidateJWTSVIDResponse, error)
	// X.509-SVID Profile
	// Fetch all SPIFFE identities the workload is entitled to, as
	// well as related information like trust bundles and CRLs. As
	// this information changes, subsequent messages will be sent.
	FetchX509SVID(ctx context.Context, in *X509SVIDRequest, opts ...grpc.CallOption) (SpiffeWorkloadAPI_FetchX509SVIDClient, error)
	FetchX509Bundles(ctx context.Context, in *X509BundlesRequest, opts ...grpc.CallOption) (SpiffeWorkloadAPI_FetchX509BundlesClient, error)
}

type spiffeWorkloadAPIClient struct {
	cc grpc.ClientConnInterface
}

func NewSpiffeWorkloadAPIClient(cc grpc.ClientConnInterface) SpiffeWorkloadAPIClient {
	return &spiffeWorkloadAPIClient{cc}
}

func (c *spiffeWorkloadAPIClient) FetchJWTSVID(ctx context.Context, in *JWTSVIDRequest, opts ...grpc.CallOption) (*JWTSVIDResponse, error) {
	out := new(JWTSVIDResponse)
	err := c.cc.Invoke(ctx, "/SpiffeWorkloadAPI/FetchJWTSVID", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spiffeWorkloadAPIClient) FetchJWTBundles(ctx context.Context, in *JWTBundlesRequest, opts ...grpc.CallOption) (SpiffeWorkloadAPI_FetchJWTBundlesClient, error) {
	stream, err := c.cc.NewStream(ctx, &SpiffeWorkloadAPI_ServiceDesc.Streams[0], "/SpiffeWorkloadAPI/FetchJWTBundles", opts...)
	if err != nil {
		return nil, err
	}
	x := &spiffeWorkloadAPIFetchJWTBundlesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type SpiffeWorkloadAPI_FetchJWTBundlesClient interface {
	Recv() (*JWTBundlesResponse, error)
	grpc.ClientStream
}

type spiffeWorkloadAPIFetchJWTBundlesClient struct {
	grpc.ClientStream
}

func (x *spiffeWorkloadAPIFetchJWTBundlesClient) Recv() (*JWTBundlesResponse, error) {
	m := new(JWTBundlesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *spiffeWorkloadAPIClient) ValidateJWTSVID(ctx context.Context, in *ValidateJWTSVIDRequest, opts ...grpc.CallOption) (*ValidateJWTSVIDResponse, error) {
	out := new(ValidateJWTSVIDResponse)
	err := c.cc.Invoke(ctx, "/SpiffeWorkloadAPI/ValidateJWTSVID", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spiffeWorkloadAPIClient) FetchX509SVID(ctx context.Context, in *X509SVIDRequest, opts ...grpc.CallOption) (SpiffeWorkloadAPI_FetchX509SVIDClient, error) {
	stream, err := c.cc.NewStream(ctx, &SpiffeWorkloadAPI_ServiceDesc.Streams[1], "/SpiffeWorkloadAPI/FetchX509SVID", opts...)
	if err != nil {
		return nil, err
	}
	x := &spiffeWorkloadAPIFetchX509SVIDClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type SpiffeWorkloadAPI_FetchX509SVIDClient interface {
	Recv() (*X509SVIDResponse, error)
	grpc.ClientStream
}

type spiffeWorkloadAPIFetchX509SVIDClient struct {
	grpc.ClientStream
}

func (x *spiffeWorkloadAPIFetchX509SVIDClient) Recv() (*X509SVIDResponse, error) {
	m := new(X509SVIDResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *spiffeWorkloadAPIClient) FetchX509Bundles(ctx context.Context, in *X509BundlesRequest, opts ...grpc.CallOption) (SpiffeWorkloadAPI_FetchX509BundlesClient, error) {
	stream, err := c.cc.NewStream(ctx, &SpiffeWorkloadAPI_ServiceDesc.Streams[2], "/SpiffeWorkloadAPI/FetchX509Bundles", opts...)
	if err != nil {
		return nil, err
	}
	x := &spiffeWorkloadAPIFetchX509BundlesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type SpiffeWorkloadAPI_FetchX509BundlesClient interface {
	Recv() (*X509BundlesResponse, error)
	grpc.ClientStream
}

type spiffeWorkloadAPIFetchX509BundlesClient struct {
	grpc.ClientStream
}

func (x *spiffeWorkloadAPIFetchX509BundlesClient) Recv() (*X509BundlesResponse, error) {
	m := new(X509BundlesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SpiffeWorkloadAPIServer is the server API for SpiffeWorkloadAPI service.
// All implementations must embed UnimplementedSpiffeWorkloadAPIServer
// for forward compatibility
type SpiffeWorkloadAPIServer interface {
	// JWT-SVID Profile
	FetchJWTSVID(context.Context, *JWTSVIDRequest) (*JWTSVIDResponse, error)
	FetchJWTBundles(*JWTBundlesRequest, SpiffeWorkloadAPI_FetchJWTBundlesServer) error
	ValidateJWTSVID(context.Context, *ValidateJWTSVIDRequest) (*ValidateJWTSVIDResponse, error)
	// X.509-SVID Profile
	// Fetch all SPIFFE identities the workload is entitled to, as
	// well as related information like trust bundles and CRLs. As
	// this information changes, subsequent messages will be sent.
	FetchX509SVID(*X509SVIDRequest, SpiffeWorkloadAPI_FetchX509SVIDServer) error
	FetchX509Bundles(*X509BundlesRequest, SpiffeWorkloadAPI_FetchX509BundlesServer) error
	mustEmbedUnimplementedSpiffeWorkloadAPIServer()
}

// UnimplementedSpiffeWorkloadAPIServer must be embedded to have forward compatible implementations.
type UnimplementedSpiffeWorkloadAPIServer struct {
}

func (UnimplementedSpiffeWorkloadAPIServer) FetchJWTSVID(context.Context, *JWTSVIDRequest) (*JWTSVIDResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchJWTSVID not implemented")
}
func (UnimplementedSpiffeWorkloadAPIServer) FetchJWTBundles(*JWTBundlesRequest, SpiffeWorkloadAPI_FetchJWTBundlesServer) error {
	return status.Errorf(codes.Unimplemented, "method FetchJWTBundles not implemented")
}
func (UnimplementedSpiffeWorkloadAPIServer) ValidateJWTSVID(context.Context, *ValidateJWTSVIDRequest) (*ValidateJWTSVIDResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateJWTSVID not implemented")
}
func (UnimplementedSpiffeWorkloadAPIServer) FetchX509SVID(*X509SVIDRequest, SpiffeWorkloadAPI_FetchX509SVIDServer) error {
	return status.Errorf(codes.Unimplemented, "method FetchX509SVID not implemented")
}
func (UnimplementedSpiffeWorkloadAPIServer) FetchX509Bundles(*X509BundlesRequest, SpiffeWorkloadAPI_FetchX509BundlesServer) error {
	return status.Errorf(codes.Unimplemented, "method FetchX509Bundles not implemented")
}
func (UnimplementedSpiffeWorkloadAPIServer) mustEmbedUnimplementedSpiffeWorkloadAPIServer() {}

// UnsafeSpiffeWorkloadAPIServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SpiffeWorkloadAPIServer will
// result in compilation errors.
type UnsafeSpiffeWorkloadAPIServer interface {
	mustEmbedUnimplementedSpiffeWorkloadAPIServer()
}

func RegisterSpiffeWorkloadAPIServer(s grpc.ServiceRegistrar, srv SpiffeWorkloadAPIServer) {
	s.RegisterService(&SpiffeWorkloadAPI_ServiceDesc, srv)
}

func _SpiffeWorkloadAPI_FetchJWTSVID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(JWTSVIDRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpiffeWorkloadAPIServer).FetchJWTSVID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/SpiffeWorkloadAPI/FetchJWTSVID",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpiffeWorkloadAPIServer).FetchJWTSVID(ctx, req.(*JWTSVIDRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpiffeWorkloadAPI_FetchJWTBundles_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(JWTBundlesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpiffeWorkloadAPIServer).FetchJWTBundles(m, &spiffeWorkloadAPIFetchJWTBundlesServer{stream})
}

type SpiffeWorkloadAPI_FetchJWTBundlesServer interface {
	Send(*JWTBundlesResponse) error
	grpc.ServerStream
}

type spiffeWorkloadAPIFetchJWTBundlesServer struct {
	grpc.ServerStream
}

func (x *spiffeWorkloadAPIFetchJWTBundlesServer) Send(m *JWTBundlesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _SpiffeWorkloadAPI_ValidateJWTSVID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateJWTSVIDRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpiffeWorkloadAPIServer).ValidateJWTSVID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/SpiffeWorkloadAPI/ValidateJWTSVID",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpiffeWorkloadAPIServer).ValidateJWTSVID(ctx, req.(*ValidateJWTSVIDRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpiffeWorkloadAPI_FetchX509SVID_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(X509SVIDRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpiffeWorkloadAPIServer).FetchX509SVID(m, &spiffeWorkloadAPIFetchX509SVIDServer{stream})
}

type SpiffeWorkloadAPI_FetchX509SVIDServer interface {
	Send(*X509SVIDResponse) error
	grpc.ServerStream
}

type spiffeWorkloadAPIFetchX509SVIDServer struct {
	grpc.ServerStream
}

func (x *spiffeWorkloadAPIFetchX509SVIDServer) Send(m *X509SVIDResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _SpiffeWorkloadAPI_FetchX509Bundles_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(X509BundlesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpiffeWorkloadAPIServer).FetchX509Bundles(m, &spiffeWorkloadAPIFetchX509BundlesServer{stream})
}

type SpiffeWorkloadAPI_FetchX509BundlesServer interface {
	Send(*X509BundlesResponse) error
	grpc.ServerStream
}

type spiffeWorkloadAPIFetchX509BundlesServer struct {
	grpc.ServerStream
}

func (x *spiffeWorkloadAPIFetchX509BundlesServer) Send(m *X509BundlesResponse) error {
	return x.ServerStream.SendMsg(m)
}

// SpiffeWorkloadAPI_ServiceDesc is the grpc.ServiceDesc for SpiffeWorkloadAPI service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SpiffeWorkloadAPI_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "SpiffeWorkloadAPI",
	HandlerType: (*SpiffeWorkloadAPIServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FetchJWTSVID",
			Handler:    _SpiffeWorkloadAPI_FetchJWTSVID_Handler,
		},
		{
			MethodName: "ValidateJWTSVID",
			Handler:    _SpiffeWorkloadAPI_ValidateJWTSVID_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "FetchJWTBundles",
			Handler:       _SpiffeWorkloadAPI_FetchJWTBundles_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FetchX509SVID",
			Handler:       _SpiffeWorkloadAPI_FetchX509SVID_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FetchX509Bundles",
			Handler:       _SpiffeWorkloadAPI_FetchX509Bundles_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "workload.proto",
}
