## v1.8.0

### Additions

- Added new bundle validator to check the bundle against the Community Operator criteria. For futher information run `operator-sdk bundle validate --list-optional` and `operator-sdk bundle validate --help`. This validator is in alpha and subject to breaking changes. ([#4939](https://github.com/operator-framework/operator-sdk/pull/4939))
- Added --extra-service-accounts flag to `generate bundle` to consider roles bound to service accounts not specified in the operator's Deployment. ([#4826](https://github.com/operator-framework/operator-sdk/pull/4826))
- Added the `quarkus/v1-alpha` Java plugin, which supports `init` and `create api` commands. This plugin is alpha and subject to breaking changes. ([#4871](https://github.com/operator-framework/operator-sdk/pull/4871))
- Add new optional flag `--skip-tls` to the commands `operator-sdk run bundle` and `operator-sdk run bundle-upgrade`. This option allows to install the operator from a bundle image stored at an insecure docker registry. (e.g. `operator-sdk run bundle localhost:5000/my-operator-bundle:latest --skip-tls`). ([#4816](https://github.com/operator-framework/operator-sdk/pull/4816))

### Changes

- `generate bundle` adds ClusterRoles bound by RoleBindings to a CSV's `.spec.permissions`, since these become namespace-scoped at runtime. They will also be added to `.spec.clusterPermissions` if bound by a ClusterRoleBinding. ([#4826](https://github.com/operator-framework/operator-sdk/pull/4826))
- Images built from the operator-sdk repository for the latest two minor version's latest patch version will now be rebuilt whenever a constituent base image has a new patch version published. For example, running `docker pull quay.io/operator-framework/ansible-operator:v1.7.2` after a rebuild will result in a fully compatible, patched image. ([#4917](https://github.com/operator-framework/operator-sdk/pull/4917))
- (go/v3) Upgraded Go version to 1.16. ([#4927](https://github.com/operator-framework/operator-sdk/pull/4927))

### Bug Fixes

- Bumped operator-framework/api to v0.8.1, which properly defaults a CRD conversion's service port to 443. ([#4903](https://github.com/operator-framework/operator-sdk/pull/4903))
- Detect and report ansible-runner binary failures early and prevent symliking to artifacts. ([#4944](https://github.com/operator-framework/operator-sdk/pull/4944))
- For Helm-based operators, fixed a bug where deployed and candidate release comparison was always false when an RNG was used to derive some manifest value, resulting in the chart release constantly upgrading. ([#4937](https://github.com/operator-framework/operator-sdk/pull/4937))
- Bumped operator-lib to v0.4.1 for several bugfixes in ansible-operator and helm-operator binaries. ([#4888](https://github.com/operator-framework/operator-sdk/pull/4888))
- Pinned pip3 to 21.1 in the ansible-operator image to fix https://github.com/pypa/pip/pull/9827. ([#4877](https://github.com/operator-framework/operator-sdk/pull/4877))
- Pinned base images of ansible-operator to ubi:8.3-297.1618432833, and helm-operator and scorecard to ubi-minimal:8.3-298.1618432845. ([#4873](https://github.com/operator-framework/operator-sdk/pull/4873))
